(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6418,        200]
NotebookOptionsPosition[      5147,        169]
NotebookOutlinePosition[      5581,        186]
CellTagsIndexPosition[      5538,        183]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "3"], "-", 
     RowBox[{"9", 
      SuperscriptBox["t", "2"]}], "+", 
     RowBox[{"26", "t"}], "-", "24"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806838211517291*^9, 3.8068382667662773`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"010b6abe-4f8a-451f-8777-9006eb82fdfc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.806838259257122*^9, 3.806838267163458*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"43ff91cf-d9df-4e4f-bc11-14b45579d3cf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", "b1"}], "+", 
       RowBox[{"3", "b2"}], "+", 
       RowBox[{"4", "b3"}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"4", "b1"}], "+", 
       RowBox[{"9", "b2"}], "+", 
       RowBox[{"16", "b3"}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"8", "b1"}], "+", 
       RowBox[{"27", "b2"}], "+", 
       RowBox[{"64", "b3"}]}], "\[Equal]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2", ",", "b3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806838692310049*^9, 3.8068387604214616`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"191b75d6-0c37-4371-a91f-97bfa3280ad0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     FractionBox["7", "4"]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["2", "3"]}]}], ",", 
    RowBox[{"b3", "\[Rule]", 
     FractionBox["1", "8"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.806838762328042*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"ae852eb6-372b-4487-bde1-a226cf71e891"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.806838937106436*^9, 3.806838947206537*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"c5349f81-ff6d-4109-9a36-8187da687869"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RR", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "26"}], ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.8068389501829753`*^9, 3.8068389853019943`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"13f3ac15-08cb-4d49-8c38-4afbdbce5397"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", " ", "n"}]]}], "+", 
    RowBox[{"21", " ", 
     SuperscriptBox["2", 
      RowBox[{"1", "+", "n"}]]}], "-", 
    RowBox[{"16", " ", 
     SuperscriptBox["3", "n"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.806838986249627*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"d5fa38c2-d43b-4b29-960b-4bd84f293620"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      FractionBox["7", "4"], 
      SuperscriptBox["2", "n"]}], "-", 
     RowBox[{
      FractionBox["2", "3"], 
      SuperscriptBox["3", "n"]}], "+", 
     RowBox[{
      FractionBox["1", "8"], 
      SuperscriptBox["4", "n"]}]}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        SuperscriptBox["2", 
         RowBox[{"2", " ", "n"}]]}], "+", 
       RowBox[{"21", " ", 
        SuperscriptBox["2", 
         RowBox[{"1", "+", "n"}]]}], "-", 
       RowBox[{"16", " ", 
        SuperscriptBox["3", "n"]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8068390558165455`*^9, 3.8068391248952937`*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"731eee6b-8c1f-4bd6-86ca-c4381e1a5eb1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.806839116916132*^9, 3.806839125788411*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"c55dc184-b2b0-4d9c-a3e2-4eeebc457ace"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"3c8c0d6b-8808-4761-af5d-faf3aa531fdc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 405, 11, 103, "Input",ExpressionUUID->"010b6abe-4f8a-451f-8777-9006eb82fdfc"],
Cell[988, 35, 392, 10, 100, "Output",ExpressionUUID->"43ff91cf-d9df-4e4f-bc11-14b45579d3cf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1417, 50, 777, 23, 145, "Input",ExpressionUUID->"191b75d6-0c37-4371-a91f-97bfa3280ad0"],
Cell[2197, 75, 417, 12, 126, "Output",ExpressionUUID->"ae852eb6-372b-4487-bde1-a226cf71e891"]
}, Open  ]],
Cell[2629, 90, 198, 3, 63, "Input",ExpressionUUID->"c5349f81-ff6d-4109-9a36-8187da687869"],
Cell[CellGroupData[{
Cell[2852, 97, 377, 9, 63, "Input",ExpressionUUID->"13f3ac15-08cb-4d49-8c38-4afbdbce5397"],
Cell[3232, 108, 461, 14, 124, "Output",ExpressionUUID->"d5fa38c2-d43b-4b29-960b-4bd84f293620"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3730, 127, 926, 29, 220, "Input",ExpressionUUID->"731eee6b-8c1f-4bd6-86ca-c4381e1a5eb1"],
Cell[4659, 158, 472, 8, 188, "Output",ExpressionUUID->"c55dc184-b2b0-4d9c-a3e2-4eeebc457ace"]
}, Open  ]]
}
]
*)

