(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7729,        226]
NotebookOptionsPosition[      6622,        200]
NotebookOutlinePosition[      7056,        217]
CellTagsIndexPosition[      7013,        214]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8068395718549695`*^9, 
  3.8068395749166813`*^9}},ExpressionUUID->"eff1d92d-3262-49fe-a854-\
835f9f46f152"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "26"}], ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", "n", ",", "b"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8068395644244623`*^9, 3.806839584180473*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"42e63ae6-3603-4552-9763-5255487d08aa"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "24"}], "+", 
    RowBox[{"26", " ", "n"}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["n", "2"]}], "+", 
    SuperscriptBox["n", "3"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -24 + 
   26 $CellContext`n - 9 $CellContext`n^2 + $CellContext`n^3, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395880860033`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"8216f3c1-e22e-482b-b179-55c156ed1083"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {2, 3, 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395881035023`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"d3690b4e-5cdf-4753-9b37-3c043698c215"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["3", "n"], " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["4", "n"], " ", 
     SubscriptBox["b", "3"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", 2^$CellContext`n Subscript[$CellContext`b, 1] + 
   3^$CellContext`n Subscript[$CellContext`b, 2] + 
   4^$CellContext`n Subscript[$CellContext`b, 3]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395881084633`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"a0e32d32-dcd3-4e36-a90b-14c5ef22f19e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{"3", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"4", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"4", " ", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{"9", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"16", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"8", " ", 
        SubscriptBox["b", "1"]}], "+", 
       RowBox[{"27", " ", 
        SubscriptBox["b", "2"]}], "+", 
       RowBox[{"64", " ", 
        SubscriptBox["b", "3"]}]}], "\[Equal]", "4"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   2 Subscript[$CellContext`b, 1] + 3 Subscript[$CellContext`b, 2] + 
     4 Subscript[$CellContext`b, 3] == 2, 
    4 Subscript[$CellContext`b, 1] + 9 Subscript[$CellContext`b, 2] + 
     16 Subscript[$CellContext`b, 3] == 3, 
    8 Subscript[$CellContext`b, 1] + 27 Subscript[$CellContext`b, 2] + 
     64 Subscript[$CellContext`b, 3] == 4}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395881144466`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"8ab2aab9-6710-4c8f-9e0b-aca8aa257a54"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      FractionBox["7", "4"]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2", "3"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      FractionBox["1", "8"]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[7, 4], 
    Subscript[$CellContext`b, 2] -> Rational[-2, 3], 
    Subscript[$CellContext`b, 3] -> Rational[1, 8]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395881174383`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"7661a762-0a0e-43a4-a157-51fd29dff52c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["2", 
        RowBox[{"2", " ", "n"}]]}], "+", 
      RowBox[{"21", " ", 
       SuperscriptBox["2", 
        RowBox[{"1", "+", "n"}]]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["3", "n"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[1, 24] (3 2^(2 $CellContext`n) + 21 2^(1 + $CellContext`n) - 16 
    3^$CellContext`n)],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068395881194324`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"d8aa7880-0f6f-47f8-9785-8e520ef01961"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f2c80b2f-0374-42a1-b45d-75ae6ffc836f"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 184, 4, 63, "Input",ExpressionUUID->"eff1d92d-3262-49fe-a854-835f9f46f152"],
Cell[CellGroupData[{
Cell[767, 28, 396, 10, 63, "Input",ExpressionUUID->"42e63ae6-3603-4552-9763-5255487d08aa"],
Cell[CellGroupData[{
Cell[1188, 42, 693, 17, 91, "Print",ExpressionUUID->"8216f3c1-e22e-482b-b179-55c156ed1083"],
Cell[1884, 61, 524, 13, 91, "Print",ExpressionUUID->"d3690b4e-5cdf-4753-9b37-3c043698c215"],
Cell[2411, 76, 876, 23, 91, "Print",ExpressionUUID->"a0e32d32-dcd3-4e36-a90b-14c5ef22f19e"],
Cell[3290, 101, 1524, 42, 171, "Print",ExpressionUUID->"8ab2aab9-6710-4c8f-9e0b-aca8aa257a54"],
Cell[4817, 145, 892, 25, 116, "Print",ExpressionUUID->"7661a762-0a0e-43a4-a157-51fd29dff52c"],
Cell[5712, 172, 882, 24, 154, "Print",ExpressionUUID->"d8aa7880-0f6f-47f8-9785-8e520ef01961"]
}, Open  ]]
}, Open  ]]
}
]
*)

