(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13425,        389]
NotebookOptionsPosition[     11861,        355]
NotebookOutlinePosition[     12295,        372]
CellTagsIndexPosition[     12252,        369]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["t", "4"], "-", 
     RowBox[{"21", 
      SuperscriptBox["t", "3"]}], "+", 
     RowBox[{"81", 
      SuperscriptBox["t", "2"]}], "+", 
     RowBox[{"729", "t"}], "-", "4374"}], "\[Equal]", "0"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.806842162030275*^9, 3.8068421942590327`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"dc98086e-93fa-4f4a-97f8-49a205d42d11"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", "6"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "9"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.806842195084588*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"9dca8f08-9172-493f-86f6-5dbb9650c7dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"36", "b1"}], "+", 
       RowBox[{"81", "b2"}], "+", 
       RowBox[{"162", "b3"}], "+", 
       RowBox[{"324", "b4"}]}], "\[Equal]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "216"}], "b1"}], "+", 
       RowBox[{"729", "b2"}], "+", 
       RowBox[{"2187", "b3"}], "+", 
       RowBox[{"6561", "b4"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"1296", "b1"}], "+", 
       RowBox[{"6561", "b2"}], "+", 
       RowBox[{"26244", "b3"}], "+", 
       RowBox[{"104976", "b4"}]}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "7776"}], "b1"}], "+", 
       RowBox[{"59049", "b2"}], "+", 
       RowBox[{"295245", "b3"}], "+", 
       RowBox[{"1476225", "b4"}]}], "\[Equal]", "7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b1", ",", "b2", ",", "b3", ",", "b4"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806843150925453*^9, 3.806843301758784*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"f061e96d-ac27-4fb1-96c6-c7ddf8ea1ac3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b1", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3419", "60750"]}]}], ",", 
    RowBox[{"b2", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["296281", "820125"]}]}], ",", 
    RowBox[{"b3", "\[Rule]", 
     FractionBox["89611", "492075"]}], ",", 
    RowBox[{"b4", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["2191", "98415"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.806843358291944*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ac228a4b-2f5e-4a01-a83f-0a98db72fabd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.806844020040058*^9, 3.8068440276771817`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"d2797d04-7f8a-4045-b939-d76c48ec3035"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MetodoRRHL", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"21", ",", 
     RowBox[{"-", "81"}], ",", 
     RowBox[{"-", "729"}], ",", "4374"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "9"}], ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "7"}], "}"}], ",", "n", ",", "b", ",", 
   RowBox[{"inicio", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8068440105091915`*^9, 3.8068440403439627`*^9}, {
  3.8068445939168825`*^9, 3.806844617109766*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"adcf95f0-d77d-4d37-83a8-c7560f6fd1a7"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: \
\"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", "4374"}], "+", 
    RowBox[{"729", " ", "n"}], "+", 
    RowBox[{"81", " ", 
     SuperscriptBox["n", "2"]}], "-", 
    RowBox[{"21", " ", 
     SuperscriptBox["n", "3"]}], "+", 
    SuperscriptBox["n", "4"]}], "\[InvisibleSpace]", "\<\"=0\"\>"}],
  SequenceForm[
  "La ecuaci\[OAcute]n caracter\[IAcute]stica corresponde a: ", -4374 + 
   729 $CellContext`n + 81 $CellContext`n^2 - 
   21 $CellContext`n^3 + $CellContext`n^4, "=0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.806844620754279*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"2738a3f6-b04e-4c5b-a3e1-7cd01e986465"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n caracter\
\[IAcute]stica: \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "6"}], ",", "9", ",", "9", ",", "9"}], "}"}]}],
  SequenceForm[
  "Ra\[IAcute]z o ra\[IAcute]ces de la ecuaci\[OAcute]n \
caracter\[IAcute]stica: ", {-6, 9, 9, 9}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806844620759266*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"416ae240-20b6-4872-bd42-22650f3ec11f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n \
de recurrencia es: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "6"}], ")"}], "n"], " ", 
     SubscriptBox["b", "1"]}], "+", 
    RowBox[{
     SuperscriptBox["9", "n"], " ", 
     SubscriptBox["b", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["9", "n"], " ", "n", " ", 
     SubscriptBox["b", "3"]}], "+", 
    RowBox[{
     SuperscriptBox["9", "n"], " ", 
     SuperscriptBox["n", "2"], " ", 
     SubscriptBox["b", "4"]}]}]}],
  SequenceForm[
  "La forma que toma la soluci\[OAcute]n de la relaci\[OAcute]n de \
recurrencia es: ", (-6)^$CellContext`n Subscript[$CellContext`b, 1] + 
   9^$CellContext`n Subscript[$CellContext`b, 2] + 
   9^$CellContext`n $CellContext`n Subscript[$CellContext`b, 3] + 
   9^$CellContext`n $CellContext`n^2 Subscript[$CellContext`b, 4]],
  Editable->False]], "Print",
 CellChangeTimes->{3.806844620762265*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"5a7bdcfc-fc79-40fd-8b1b-f742190f6f34"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"El sistema de ecuaciones a resolver corresponde a: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"9", " ", 
          SubscriptBox["b", "2"]}], "+", 
         RowBox[{"18", " ", 
          SubscriptBox["b", "3"]}], "+", 
         RowBox[{"36", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", 
      RowBox[{"-", "9"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "27"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SubscriptBox["b", "1"]}], "-", 
         RowBox[{"27", " ", 
          SubscriptBox["b", "2"]}], "-", 
         RowBox[{"81", " ", 
          SubscriptBox["b", "3"]}], "-", 
         RowBox[{"243", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"81", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SubscriptBox["b", "1"]}], "+", 
         RowBox[{"81", " ", 
          SubscriptBox["b", "2"]}], "+", 
         RowBox[{"324", " ", 
          SubscriptBox["b", "3"]}], "+", 
         RowBox[{"1296", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "243"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"32", " ", 
          SubscriptBox["b", "1"]}], "-", 
         RowBox[{"243", " ", 
          SubscriptBox["b", "2"]}], "-", 
         RowBox[{"1215", " ", 
          SubscriptBox["b", "3"]}], "-", 
         RowBox[{"6075", " ", 
          SubscriptBox["b", "4"]}]}], ")"}]}], "\[Equal]", "7"}]}], "}"}]}],
  SequenceForm[
  "El sistema de ecuaciones a resolver corresponde a: ", {
   9 (4 Subscript[$CellContext`b, 1] + 9 Subscript[$CellContext`b, 2] + 
      18 Subscript[$CellContext`b, 3] + 
      36 Subscript[$CellContext`b, 4]) == -9, (-27) (
      8 Subscript[$CellContext`b, 1] - 27 Subscript[$CellContext`b, 2] - 81 
      Subscript[$CellContext`b, 3] - 243 Subscript[$CellContext`b, 4]) == 1, 
    81 (16 Subscript[$CellContext`b, 1] + 81 Subscript[$CellContext`b, 2] + 
      324 Subscript[$CellContext`b, 3] + 
      1296 Subscript[$CellContext`b, 4]) == -1, (-243) (
      32 Subscript[$CellContext`b, 1] - 243 Subscript[$CellContext`b, 2] - 
      1215 Subscript[$CellContext`b, 3] - 6075 Subscript[$CellContext`b, 4]) == 
    7}],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068446207851973`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"579e03b3-907d-4f8d-b823-48b28ad1355e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n del sistema de ecuaciones es: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3419", "60750"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "2"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["296281", "820125"]}]}], ",", 
     RowBox[{
      SubscriptBox["b", "3"], "\[Rule]", 
      FractionBox["89611", "492075"]}], ",", 
     RowBox[{
      SubscriptBox["b", "4"], "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2191", "98415"]}]}]}], "}"}]}],
  SequenceForm[
  "La soluci\[OAcute]n del sistema de ecuaciones es: ", {
   Subscript[$CellContext`b, 1] -> Rational[-3419, 60750], 
    Subscript[$CellContext`b, 2] -> Rational[-296281, 820125], 
    Subscript[$CellContext`b, 3] -> Rational[89611, 492075], 
    Subscript[$CellContext`b, 4] -> Rational[-2191, 98415]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.806844620787193*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"53c23a8c-c949-4609-804a-934538021488"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia \
corresponde a: \"\>", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "250"]}], " ", 
    SuperscriptBox["3", 
     RowBox[{
      RowBox[{"-", "9"}], "+", "n"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"276939", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], "n"]}], "+", 
      RowBox[{"592562", " ", 
       SuperscriptBox["3", 
        RowBox[{"1", "+", "n"}]]}], "-", 
      RowBox[{"896110", " ", 
       SuperscriptBox["3", "n"], " ", "n"}], "+", 
      RowBox[{"109550", " ", 
       SuperscriptBox["3", "n"], " ", 
       SuperscriptBox["n", "2"]}]}], ")"}]}]}],
  SequenceForm[
  "La soluci\[OAcute]n de la relaci\[OAcute]n de recurrencia corresponde a: ",
    Rational[-1, 250] 
   3^(-9 + $CellContext`n) (276939 (-2)^$CellContext`n + 
    592562 3^(1 + $CellContext`n) - 896110 3^$CellContext`n $CellContext`n + 
    109550 3^$CellContext`n $CellContext`n^2)],
  Editable->False]], "Print",
 CellChangeTimes->{3.8068446207891893`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[6]:=",ExpressionUUID->"04838b44-761d-43d6-a3eb-fcfce034a082"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c29a08cb-97dd-4e64-b4ca-30221099d455"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 470, 13, 103, "Input",ExpressionUUID->"dc98086e-93fa-4f4a-97f8-49a205d42d11"],
Cell[1053, 37, 455, 13, 100, "Output",ExpressionUUID->"9dca8f08-9172-493f-86f6-5dbb9650c7dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1545, 55, 1213, 36, 274, "Input",ExpressionUUID->"f061e96d-ac27-4fb1-96c6-c7ddf8ea1ac3"],
Cell[2761, 93, 561, 16, 198, "Output",ExpressionUUID->"ac228a4b-2f5e-4a01-a83f-0a98db72fabd"]
}, Open  ]],
Cell[3337, 112, 200, 3, 63, "Input",ExpressionUUID->"d2797d04-7f8a-4045-b939-d76c48ec3035"],
Cell[CellGroupData[{
Cell[3562, 119, 579, 14, 107, "Input",ExpressionUUID->"adcf95f0-d77d-4d37-83a8-c7560f6fd1a7"],
Cell[CellGroupData[{
Cell[4166, 137, 788, 20, 91, "Print",ExpressionUUID->"2738a3f6-b04e-4c5b-a3e1-7cd01e986465"],
Cell[4957, 159, 557, 14, 91, "Print",ExpressionUUID->"416ae240-20b6-4872-bd42-22650f3ec11f"],
Cell[5517, 175, 1145, 30, 131, "Print",ExpressionUUID->"5a7bdcfc-fc79-40fd-8b1b-f742190f6f34"],
Cell[6665, 207, 2761, 75, 251, "Print",ExpressionUUID->"579e03b3-907d-4f8d-b823-48b28ad1355e"],
Cell[9429, 284, 1150, 31, 184, "Print",ExpressionUUID->"53c23a8c-c949-4609-804a-934538021488"],
Cell[10582, 317, 1251, 34, 203, "Print",ExpressionUUID->"04838b44-761d-43d6-a3eb-fcfce034a082"]
}, Open  ]]
}, Open  ]]
}
]
*)

