(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     36936,        847]
NotebookOptionsPosition[     34679,        804]
NotebookOutlinePosition[     35113,        821]
CellTagsIndexPosition[     35070,        818]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8050538605526037`*^9, 3.805053871015532*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"18effa71-b7ad-43c1-82e1-73a064a71e86"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "PotenciaPos"}]], "Input",
 CellChangeTimes->{{3.805053918308277*^9, 3.805053923794178*^9}, {
  3.8050540134233255`*^9, 3.805054048835906*^9}, {3.8051149817963495`*^9, 
  3.8051149821150656`*^9}},ExpressionUUID->"e8351aaf-2117-4e60-9abd-\
4d9114965d6c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Determina de manera recursiva la potencia de un n\
\[UAcute]mero real, siendo el exponente un n\[UAcute]mero natural o cero. La \
funci\[OAcute]n permite visualizar los resultados devueltos paso a paso y el \
c\[OAcute]digo de programaci\[OAcute]n. Sintaxis: PotenciaPos[a, n], o bien, \
PotenciaPos[a, n, code->Valor, steps->Valor], \
\[OpenCurlyDoubleQuote]code->True\[CloseCurlyDoubleQuote] genera el contenido \
de la funci\[OAcute]n y \[OpenCurlyDoubleQuote]steps->True\
\[CloseCurlyDoubleQuote] las iteraciones invocaci\[OAcute]n a invocaci\
\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"PotenciaPos", "[", 
                    RowBox[{
                    "VilCretas`Private`Ra_", ",", "VilCretas`Private`Rn_", 
                    ",", 
                    RowBox[{"OptionsPattern", "[", "]"}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RPotenciaPos", ",", 
                    "VilCretas`Private`RPotenciaPosSteps"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{
                    "VilCretas`Private`Rb_", ",", "VilCretas`Private`Rm_"}], 
                    "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rb", "]"}], "&&", 
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rm", "]"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Rm", "\[GreaterEqual]", "0"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rb", "\[Equal]", "0"}], "&&", 
                    RowBox[{"VilCretas`Private`Rm", "\[Equal]", "0"}]}], 
                    ",", "\<\"Indefinido\"\>", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rb", "\[Equal]", "0"}], ",", 
                    "0", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rm", "\[Equal]", "0"}], ",", 
                    "1", ",", 
                    RowBox[{"VilCretas`Private`Rb", " ", 
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{"VilCretas`Private`Rb", ",", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RPotenciaPosSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Rb_", ",", "VilCretas`Private`Rm_"}], 
                    "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rb", "]"}], "&&", 
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rm", "]"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Rm", "\[GreaterEqual]", "0"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rb", "\[Equal]", "0"}], "&&", 
                    RowBox[{"VilCretas`Private`Rm", "\[Equal]", "0"}]}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"PotenciaPos[\"\>", ",", 
                    "VilCretas`Private`Rb", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`Rm", ",", "\<\"] = Indefinido\"\>"}], 
                    "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rb", "\[Equal]", "0"}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"PotenciaPos[\"\>", ",", 
                    "VilCretas`Private`Rb", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`Rm", ",", "\<\"] = 0\"\>"}], "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rm", "\[Equal]", "0"}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"PotenciaPos[\"\>", ",", 
                    "VilCretas`Private`Rb", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`Rm", ",", "\<\"] = 1\"\>"}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"PotenciaPos[\"\>", ",", 
                    "VilCretas`Private`Rb", ",", "\<\",\"\>", ",", 
                    "VilCretas`Private`Rm", ",", "\<\"] = \"\>", ",", 
                    "VilCretas`Private`Rb", ",", "\<\"*PotenciaPos[\"\>", ",",
                     "VilCretas`Private`Rb", ",", "\<\",\"\>", ",", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}], 
                    ",", "\<\"] = \"\>", ",", 
                    RowBox[{"VilCretas`Private`Rb", " ", 
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{"VilCretas`Private`Rb", ",", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}]}], "]"}]}]}], 
                    "]"}], ";", 
                    RowBox[{"VilCretas`Private`RPotenciaPosSteps", "[", 
                    RowBox[{"VilCretas`Private`Rb", ",", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "steps", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "code", "]"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "&&", 
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Ra", "]"}], "&&", 
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rn", "]"}], "&&", 
                    RowBox[{
                    "VilCretas`Private`Rn", "\[GreaterEqual]", "0"}]}], ",", 
                    RowBox[{"Print", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{
                    "VilCretas`Private`Ra", ",", "VilCretas`Private`Rn"}], 
                    "]"}], ",", "\<\"Potencia[a_,n_]:=If[And[a\[Equal]0, n\
\[Equal]0], \
Return[\[OpenCurlyDoubleQuote]Indefinido\[CloseCurlyDoubleQuote]],If[a\[Equal]\
0,Return[0],If[n\[Equal]0, Return[1],a*Potencia[a,n-1]]]]\"\>"}], "}"}], 
                    "]"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "steps", "]"}], "]"}], "&&", 
                    RowBox[{"BooleanQ", "[", 
                    RowBox[{"OptionValue", "[", "code", "]"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"OptionValue", "[", "steps", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RPotenciaPosSteps", "[", 
                    RowBox[{
                    "VilCretas`Private`Ra", ",", "VilCretas`Private`Rn"}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`RPotenciaPos", "[", 
                    "VilCretas`Private`Rn", "]"}], "]"}], "\[NotEqual]", 
                    RowBox[{"ToString", "[", "Null", "]"}]}], ",", 
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{"VilCretas`Private`Ra", ",", 
                    "VilCretas`Private`Rn"}], "]"}]}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"OptionValue", "[", "code", "]"}], "\[Equal]", 
                    "False"}], ",", 
                    RowBox[{"VilCretas`Private`RPotenciaPos", "[", 
                    RowBox[{
                    "VilCretas`Private`Ra", ",", "VilCretas`Private`Rn"}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Options\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Options\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Options", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"code", "\[Rule]", "False"}], ",", 
                    RowBox[{"steps", "\[Rule]", "False"}]}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`PotenciaPos\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Determina de manera recursiva la potencia de un n\
\[UAcute]mero real, siendo el exponente un n\[UAcute]mero natural o cero. La \
funci\[OAcute]n permite visualizar los resultados devueltos paso a paso y el \
c\[OAcute]digo de programaci\[OAcute]n. Sintaxis: PotenciaPos[a, n], o bien, \
PotenciaPos[a, n, code->Valor, steps->Valor], \
\[OpenCurlyDoubleQuote]code->True\[CloseCurlyDoubleQuote] genera el contenido \
de la funci\[OAcute]n y \[OpenCurlyDoubleQuote]steps->True\
\[CloseCurlyDoubleQuote] las iteraciones invocaci\[OAcute]n a invocaci\
\[OAcute]n.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{15., {5., 10.}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{15., {5., 10.}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Determina de manera recursiva la potencia de un n\[UAcute]mero real, \
siendo el exponente un n\[UAcute]mero natural o cero. La funci\[OAcute]n \
permite visualizar los resultados devueltos paso a paso y el c\[OAcute]digo \
de programaci\[OAcute]n. Sintaxis: PotenciaPos[a, n], o bien, PotenciaPos[a, \
n, code->Valor, steps->Valor], \[OpenCurlyDoubleQuote]code->True\
\[CloseCurlyDoubleQuote] genera el contenido de la funci\[OAcute]n y \
\[OpenCurlyDoubleQuote]steps->True\[CloseCurlyDoubleQuote] las iteraciones \
invocaci\[OAcute]n a invocaci\[OAcute]n.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`PotenciaPos, {VilCretas`PotenciaPos[
         Pattern[VilCretas`Private`Ra, 
          Blank[]], 
         Pattern[VilCretas`Private`Rn, 
          Blank[]], 
         OptionsPattern[]] :> 
       Module[{VilCretas`Private`RPotenciaPos, 
          VilCretas`Private`RPotenciaPosSteps}, VilCretas`Private`RPotenciaPos[
            Pattern[VilCretas`Private`Rb, 
             Blank[]], 
            Pattern[VilCretas`Private`Rm, 
             Blank[]]] := If[
            And[
             NumericQ[VilCretas`Private`Rb], 
             IntegerQ[VilCretas`Private`Rm], VilCretas`Private`Rm >= 0], 
            If[
             And[VilCretas`Private`Rb == 0, VilCretas`Private`Rm == 0], 
             "Indefinido", 
             If[VilCretas`Private`Rb == 0, 0, 
              If[
              VilCretas`Private`Rm == 0, 1, VilCretas`Private`Rb 
               VilCretas`Private`RPotenciaPos[
                VilCretas`Private`Rb, VilCretas`Private`Rm - 1]]]]]; 
         VilCretas`Private`RPotenciaPosSteps[
            Pattern[VilCretas`Private`Rb, 
             Blank[]], 
            Pattern[VilCretas`Private`Rm, 
             Blank[]]] := If[
            And[
             NumericQ[VilCretas`Private`Rb], 
             IntegerQ[VilCretas`Private`Rm], VilCretas`Private`Rm >= 0], 
            If[
             And[VilCretas`Private`Rb == 0, VilCretas`Private`Rm == 0], 
             Print[
             "PotenciaPos[", VilCretas`Private`Rb, ",", VilCretas`Private`Rm, 
              "] = Indefinido"], 
             If[VilCretas`Private`Rb == 0, 
              Print[
              "PotenciaPos[", VilCretas`Private`Rb, ",", VilCretas`Private`Rm,
                "] = 0"], 
              If[VilCretas`Private`Rm == 0, 
               Print[
               "PotenciaPos[", VilCretas`Private`Rb, ",", 
                VilCretas`Private`Rm, "] = 1"], 
               Print["PotenciaPos[", VilCretas`Private`Rb, ",", 
                 VilCretas`Private`Rm, "] = ", VilCretas`Private`Rb, 
                 "*PotenciaPos[", VilCretas`Private`Rb, ",", 
                 VilCretas`Private`Rm - 1, "] = ", VilCretas`Private`Rb 
                 VilCretas`Private`RPotenciaPos[
                  VilCretas`Private`Rb, VilCretas`Private`Rm - 1]]; 
               VilCretas`Private`RPotenciaPosSteps[
                VilCretas`Private`Rb, VilCretas`Private`Rm - 1]]]]]; If[
           And[
            BooleanQ[
             OptionValue[VilCretas`steps]], 
            BooleanQ[
             OptionValue[VilCretas`code]]], 
           If[
            And[
             OptionValue[VilCretas`code], 
             NumericQ[VilCretas`Private`Ra], 
             IntegerQ[VilCretas`Private`Rn], VilCretas`Private`Rn >= 0], 
            Print[{
              VilCretas`Private`RPotenciaPos[
              VilCretas`Private`Ra, VilCretas`Private`Rn], 
              "Potencia[a_,n_]:=If[And[a\[Equal]0, n\[Equal]0], Return[\
\[OpenCurlyDoubleQuote]Indefinido\[CloseCurlyDoubleQuote]],If[a\[Equal]0,\
Return[0],If[n\[Equal]0, Return[1],a*Potencia[a,n-1]]]]"}]]]; If[
           And[
            BooleanQ[
             OptionValue[VilCretas`steps]], 
            BooleanQ[
             OptionValue[VilCretas`code]]], 
           If[
            OptionValue[VilCretas`steps], 
            VilCretas`Private`RPotenciaPosSteps[
             VilCretas`Private`Ra, VilCretas`Private`Rn]; If[ToString[
                VilCretas`Private`RPotenciaPos[VilCretas`Private`Rn]] != 
              ToString[Null], 
              VilCretas`Private`RPotenciaPos[
              VilCretas`Private`Ra, VilCretas`Private`Rn]], 
            If[OptionValue[VilCretas`code] == False, 
             VilCretas`Private`RPotenciaPos[
             VilCretas`Private`Ra, VilCretas`Private`Rn]]]]]}], "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> {VilCretas`code -> False, VilCretas`steps -> False}, 
    "Attributes" -> {Protected}, "FullName" -> "VilCretas`PotenciaPos"], 
   False]]], "Output",
 CellChangeTimes->{
  3.8050539245444946`*^9, {3.8050540138907814`*^9, 3.8050540497944503`*^9}, 
   3.8051114173480587`*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"08c3f9cf-d210-4ce3-ad0f-b8ca753e60dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PotenciaPos", "[", 
  RowBox[{"5", ",", "4", ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805053881716838*^9, 3.8050539076112585`*^9}, {
  3.8050540066349735`*^9, 3.805054007095604*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"071fce54-7d54-4b70-ab96-b4d3c20f6ae6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "625", ",", "\<\"Potencia[a_,n_]:=If[And[a\[Equal]0, n\[Equal]0], Return[\
\[OpenCurlyDoubleQuote]Indefinido\[CloseCurlyDoubleQuote]],If[a\[Equal]0,\
Return[0],If[n\[Equal]0, Return[1],a*Potencia[a,n-1]]]]\"\>"}], 
  "}"}]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.8051114208478527`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"21f2fb86-4dc8-4571-af12-aefb8c1c04df"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"*PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "625"}],
  SequenceForm[
  "PotenciaPos[", 5, ",", 4, "] = ", 5, "*PotenciaPos[", 5, ",", 3, "] = ", 
   625],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.8051114208478527`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"7c1a211e-9566-47ab-bb81-901222bde470"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"*PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "125"}],
  SequenceForm[
  "PotenciaPos[", 5, ",", 3, "] = ", 5, "*PotenciaPos[", 5, ",", 2, "] = ", 
   125],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.805111420864529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"db14b346-deb2-447d-b796-f85af7effcbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"*PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "25"}],
  SequenceForm[
  "PotenciaPos[", 5, ",", 2, "] = ", 5, "*PotenciaPos[", 5, ",", 1, "] = ", 
   25],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.805111420864529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"7befa9ae-af9f-4ffa-b984-bfff0b41cb37"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"*PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", "5"}],
  SequenceForm[
  "PotenciaPos[", 5, ",", 1, "] = ", 5, "*PotenciaPos[", 5, ",", 0, "] = ", 5],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.805111420864529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"77766abf-3bc1-47b8-b055-892154abacf0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaPos[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = 1\"\>"}],
  SequenceForm["PotenciaPos[", 5, ",", 0, "] = 1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054007877718*^9, 3.805054055860777*^9, 
  3.805111420864529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"4621ec94-a90c-4468-9697-fab5f66bdacf"]
}, Open  ]],

Cell[BoxData["625"], "Output",
 CellChangeTimes->{3.805054007894347*^9, 3.805054055860777*^9, 
  3.805111420864529*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"f2265cc6-308e-4c09-a435-d729d0e7ac4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PotenciaNeg", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"code", "\[Rule]", "True"}], ",", 
   RowBox[{"steps", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805054063285413*^9, 3.805054066020667*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"a81be298-42ae-40a7-8ac6-dbd239ba8aa2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "625"], 
   ",", "\<\"Potencia[a_,n_]:=If[And[a\[Equal]0, n\[Equal]0], Return[\
\[OpenCurlyDoubleQuote]Indefinido\[CloseCurlyDoubleQuote]],If[a\[Equal]0,\
Return[\[OpenCurlyDoubleQuote]Indefinido\[CloseCurlyDoubleQuote]],If[n\[Equal]\
0, Return[1],\\!\\(\\*FractionBox[\\(1\\), \
\\(a\\)]\\)*Potencia[a,n+1]]]]\"\>"}], "}"}]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423797656*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"5fe337dc-4df0-4dc0-801f-b4ac154341e5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaNeg[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "5"], "\[InvisibleSpace]", "\<\"*PotenciaNeg[\"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "3"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "625"]}],
  SequenceForm["PotenciaNeg[", 5, ",", -4, "] = ", 
   Rational[1, 5], "*PotenciaNeg[", 5, ",", -3, "] = ", 
   Rational[1, 625]],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423797656*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"5234e8e6-9fd9-4183-9a3e-4dc67e0a7f3f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaNeg[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "3"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "5"], "\[InvisibleSpace]", "\<\"*PotenciaNeg[\"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "2"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "125"]}],
  SequenceForm["PotenciaNeg[", 5, ",", -3, "] = ", 
   Rational[1, 5], "*PotenciaNeg[", 5, ",", -2, "] = ", 
   Rational[1, 125]],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423797656*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"104bfdae-889e-4cd9-99b2-e86e4cd1034f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaNeg[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "2"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "5"], "\[InvisibleSpace]", "\<\"*PotenciaNeg[\"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "25"]}],
  SequenceForm["PotenciaNeg[", 5, ",", -2, "] = ", 
   Rational[1, 5], "*PotenciaNeg[", 5, ",", -1, "] = ", 
   Rational[1, 25]],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423813302*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"796cc24b-746b-43a8-a55a-44bd55644ab7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaNeg[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "5"], "\[InvisibleSpace]", "\<\"*PotenciaNeg[\"\>", 
   "\[InvisibleSpace]", "5", "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "0", "\[InvisibleSpace]", "\<\"] = \"\>", 
   "\[InvisibleSpace]", 
   FractionBox["1", "5"]}],
  SequenceForm["PotenciaNeg[", 5, ",", -1, "] = ", 
   Rational[1, 5], "*PotenciaNeg[", 5, ",", 0, "] = ", 
   Rational[1, 5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423814308*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"de65d2ed-1793-462b-b8e5-817b0eed64ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PotenciaNeg[\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", "0", 
   "\[InvisibleSpace]", "\<\"] = 1\"\>"}],
  SequenceForm["PotenciaNeg[", 5, ",", 0, "] = 1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805054066644496*^9, 3.805111423814308*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"253e25ca-fa8a-45b3-a01c-a358368ba2ac"]
}, Open  ]],

Cell[BoxData[
 FractionBox["1", "625"]], "Output",
 CellChangeTimes->{3.8050540666777554`*^9, 3.805111423814308*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"3e1d911c-4be1-4e4e-9970-9bd19665b3bc"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{Automatic, -5.5}, {-5.5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"000b5b03-9980-4a94-8655-c37db9f8220b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 42, "Input",ExpressionUUID->"18effa71-b7ad-43c1-82e1-73a064a71e86"],
Cell[CellGroupData[{
Cell[783, 27, 281, 5, 42, "Input",ExpressionUUID->"e8351aaf-2117-4e60-9abd-4d9114965d6c"],
Cell[1067, 34, 23807, 521, 288, "Output",ExpressionUUID->"08c3f9cf-d210-4ce3-ad0f-b8ca753e60dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24911, 560, 377, 7, 65, "Input",ExpressionUUID->"071fce54-7d54-4b70-ab96-b4d3c20f6ae6"],
Cell[CellGroupData[{
Cell[25313, 571, 482, 11, 86, "Print",ExpressionUUID->"21f2fb86-4dc8-4571-af12-aefb8c1c04df"],
Cell[25798, 584, 774, 16, 33, "Print",ExpressionUUID->"7c1a211e-9566-47ab-bb81-901222bde470"],
Cell[26575, 602, 772, 16, 33, "Print",ExpressionUUID->"db14b346-deb2-447d-b796-f85af7effcbd"],
Cell[27350, 620, 770, 16, 33, "Print",ExpressionUUID->"7befa9ae-af9f-4ffa-b984-bfff0b41cb37"],
Cell[28123, 638, 764, 15, 33, "Print",ExpressionUUID->"77766abf-3bc1-47b8-b055-892154abacf0"],
Cell[28890, 655, 488, 11, 33, "Print",ExpressionUUID->"4621ec94-a90c-4468-9697-fab5f66bdacf"]
}, Open  ]],
Cell[29393, 669, 197, 3, 48, "Output",ExpressionUUID->"f2265cc6-308e-4c09-a435-d729d0e7ac4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29627, 677, 343, 7, 64, "Input",ExpressionUUID->"a81be298-42ae-40a7-8ac6-dbd239ba8aa2"],
Cell[CellGroupData[{
Cell[29995, 688, 575, 12, 104, "Print",ExpressionUUID->"5fe337dc-4df0-4dc0-801f-b4ac154341e5"],
Cell[30573, 702, 858, 19, 54, "Print",ExpressionUUID->"5234e8e6-9fd9-4183-9a3e-4dc67e0a7f3f"],
Cell[31434, 723, 858, 19, 54, "Print",ExpressionUUID->"104bfdae-889e-4cd9-99b2-e86e4cd1034f"],
Cell[32295, 744, 856, 19, 54, "Print",ExpressionUUID->"796cc24b-746b-43a8-a55a-44bd55644ab7"],
Cell[33154, 765, 834, 18, 54, "Print",ExpressionUUID->"de65d2ed-1793-462b-b8e5-817b0eed64ed"],
Cell[33991, 785, 463, 10, 33, "Print",ExpressionUUID->"253e25ca-fa8a-45b3-a01c-a358368ba2ac"]
}, Open  ]],
Cell[34469, 798, 194, 3, 92, "Output",ExpressionUUID->"3e1d911c-4be1-4e4e-9970-9bd19665b3bc"]
}, Open  ]]
}
]
*)

