(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     47939,       1118]
NotebookOptionsPosition[     46173,       1082]
NotebookOutlinePosition[     46607,       1099]
CellTagsIndexPosition[     46564,       1096]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8051180835313044`*^9, 3.8051180914154015`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"a44b58f6-8155-4e6f-892f-8d8a0cd9f2e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sumatoria", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", 
    RowBox[{"n", "-", "10"}], ",", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"2", ",", "i"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"i", "^", "2"}], "+", "1"}], ")"}]}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.805118139741064*^9, 3.8051181804146643`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"ccd2e7f3-100a-47b3-9ca8-02c3008d5b0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "5", "]"}], 
    RowBox[{"26", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"Sumatoria[n-1]+\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "10"}], "+", "n"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10"}], "+", "n"}], ")"}], "2"]}], ")"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "Sumatoria[n_]:=If[n\[Equal]", 15, ",", Rational[1, 26] Log[2]^(-1) Log[5], 
   ",", "Sumatoria[n-1]+", (1 + (-10 + $CellContext`n)^2)^(-1) Log[2]^(-1) 
   Log[-10 + $CellContext`n], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051181849144115`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[2]:=",ExpressionUUID->"d7903703-cc5f-409a-b9f8-fd6470b0e961"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Sumatoria"}]], "Input",
 CellChangeTimes->{{3.8051185407438765`*^9, 3.8051185407458706`*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"44373834-2856-46ff-bc47-2ce94abff308"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Construye de manera autom\[AAcute]tica un programa \
recursivo para calcular una sumatoria ingresada por el usuario, la instrucci\
\[OAcute]n adem\[AAcute]s, facilita el c\[AAcute]lculo paso a paso para un \
valor de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] (\[IAcute]ndice \
superior de la suma) especificado como par\[AAcute]metro. Sintaxis: \
Sumatoria[suma], o bien, Sumatoria[suma, n], suma es un vector con tres \
componentes en el siguiente orden: el \[IAcute]ndice inferior, el \
\[IAcute]ndice superior (en funci\[OAcute]n de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote]) y la expresi\[OAcute]n interna de la sumatoria (en \
funci\[OAcute]n de \[OpenCurlyDoubleQuote]i\[CloseCurlyDoubleQuote]).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"Sumatoria", "[", 
                    RowBox[{"VilCretas`Private`Rsuma_", ",", 
                    RowBox[{"VilCretas`Private`Rn_", ":", 
                    FractionBox["1", "1000000000"]}]}], "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilCretas`Private`FuncionVariable", "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`FuncionVariable", "[", 
                    "VilCretas`Private`FuncionVariable_List", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`FuncionVariableAuxiliar", ",", 
                    "VilCretas`Private`Simbolos", ",", 
                    "VilCretas`Private`VariableAuxiliarSimbolos", ",", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarVariables", "=", 
                    RowBox[{"{", "}"}]}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`FuncionVariableAuxiliar", "[", "]"}], ":=", 
                    RowBox[{
                    "VilCretas`Private`FuncionVariable", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Simbolos", "[", 
                    "VilCretas`Private`VariableFuncion_", "]"}], ":=", 
                    RowBox[{"DeleteDuplicates", "[", 
                    RowBox[{"Cases", "[", 
                    RowBox[{
                    RowBox[{
                    "DownValues", "[", "VilCretas`Private`VariableFuncion", 
                    "]"}], ",", "_Symbol", ",", "\[Infinity]"}], "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilCretas`Private`VariableAuxiliarSimbolos", "=", 
                    RowBox[{"Sort", "[", 
                    RowBox[{
                    "VilCretas`Private`Simbolos", "[", 
                    "VilCretas`Private`FuncionVariableAuxiliar", "]"}], 
                    "]"}]}], ";", 
                    RowBox[{"For", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`VariableFuncioni", "=", "1"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`VariableFuncioni", "\[LessEqual]", 
                    RowBox[{
                    "Length", "[", 
                    "VilCretas`Private`VariableAuxiliarSimbolos", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarSimbolos", 
                    "\[LeftDoubleBracket]", 
                    "VilCretas`Private`VariableFuncioni", 
                    "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "False"}], 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarVariables", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarVariables", ",", 
                    RowBox[{
                    "VilCretas`Private`VariableAuxiliarSimbolos", 
                    "\[LeftDoubleBracket]", 
                    "VilCretas`Private`VariableFuncioni", 
                    "\[RightDoubleBracket]"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"VilCretas`Private`VariableFuncioni", "++"}]}]}], 
                    "]"}], ";", 
                    "VilCretas`Private`VariableAuxiliarVariables"}]}], 
                    "]"}]}], ";", 
                    RowBox[{"Quiet", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VectorQ", "[", "VilCretas`Private`Rsuma", "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"MemberQ", "[", 
                    RowBox[{"VilCretas`Private`Rsuma", ",", "Null"}], "]"}], 
                    "\[Equal]", "False"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilCretas`Private`Rsuma", "]"}], 
                    "\[Equal]", "3"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    RowBox[{"n", ",", "i"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilCretas`Private`FuncionVariable", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "}"}], "]"}], "]"}], 
                    "\[Equal]", "\<\"{n}\"\>"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "]"}], ",", "\<\"i\"\>"}], 
                    "]"}], "||", 
                    RowBox[{"NumericQ", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"PolynomialQ", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "n"}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Exponent", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "n"}], "]"}], "\[Equal]", 
                    "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Coefficient", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "n"}], "]"}], "\[Equal]", 
                    "1"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilCretas`Private`Rn", "]"}], 
                    ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "VilCretas`Private`RS", ",", "VilCretas`Private`RIS", ",",
                     "VilCretas`Private`RSumatoria", ",", 
                    "VilCretas`Private`RSumatoriaSteps"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RVl17", "=", "i"}], ";", 
                    RowBox[{"VilCretas`Private`RVl18", "=", 
                    RowBox[{
                    RowBox[{"Variables", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RIS", "[", "VilCretas`Private`Ri_", 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{
                    "VilCretas`Private`RVl18", "\[Rule]", 
                    "VilCretas`Private`Ri"}]}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`Ri_", 
                    "]"}], ":=", 
                    RowBox[{
                    RowBox[{"Together", "[", 
                    RowBox[{"Expand", "[", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "3", 
                    "\[RightDoubleBracket]"}], "]"}], "]"}], "/.", 
                    "\[VeryThinSpace]", 
                    RowBox[{"VilCretas`Private`RVl17", "\[Rule]", 
                    RowBox[{
                    "VilCretas`Private`RIS", "[", "VilCretas`Private`Ri", 
                    "]"}]}]}]}], ";", 
                    RowBox[{"VilCretas`Private`RVl19", "=", 
                    RowBox[{
                    "VilCretas`Private`RVl18", "/.", "\[VeryThinSpace]", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"Solve", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "\[Equal]", 
                    RowBox[{
                    "VilCretas`Private`Rsuma", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], "]"}], 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"IntegerQ", "[", "VilCretas`Private`Rn", "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rn", "\[GreaterEqual]", 
                    "VilCretas`Private`RVl19"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RSumatoria", "[", 
                    "VilCretas`Private`Rm_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rm", "\[Equal]", 
                    "VilCretas`Private`RVl19"}], ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl19", 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RSumatoria", "[", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}], "]"}], "+", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`Rm", 
                    "]"}]}]}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`RSumatoriaSteps", "[", 
                    "VilCretas`Private`Rm_", "]"}], ":=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "VilCretas`Private`Rm", "\[Equal]", 
                    "VilCretas`Private`RVl19"}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Sumatoria[\"\>", ",", 
                    "VilCretas`Private`RVl19", ",", "\<\"] = \"\>", ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl19", 
                    "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Sumatoria[\"\>", ",", "VilCretas`Private`Rm",
                     ",", "\<\"] = Sumatoria[\"\>", ",", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}], 
                    ",", "\<\"] + \"\>", ",", 
                    RowBox[{"VilCretas`Private`RS", "[", 
                    "VilCretas`Private`Rm", "]"}], ",", "\<\" = \"\>", ",", 
                    RowBox[{
                    "VilCretas`Private`RSumatoria", "[", 
                    "VilCretas`Private`Rm", "]"}]}], "]"}], ";", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`RSumatoriaSteps", "[", 
                    RowBox[{"VilCretas`Private`Rm", "-", "1"}], "]"}], "+", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`Rm", 
                    "]"}]}], ";", 
                    RowBox[{
                    "VilCretas`Private`RSumatoria", "[", 
                    "VilCretas`Private`Rm", "]"}]}]}], "]"}]}], ";", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", ",", 
                    "VilCretas`Private`RVl19", ",", "\<\",\"\>", ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl19", 
                    "]"}], ",", "\<\",\"\>", ",", "\<\"Sumatoria[n-1]+\"\>", 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl18", 
                    "]"}], ",", "\<\"]\"\>"}], "]"}], ";", 
                    RowBox[{
                    "VilCretas`Private`RSumatoriaSteps", "[", 
                    "VilCretas`Private`Rn", "]"}]}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilCretas`Private`Rn", "\[Equal]", 
                    FractionBox["1", "1000000000"]}], ",", 
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", ",", 
                    "VilCretas`Private`RVl19", ",", "\<\",\"\>", ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl19", 
                    "]"}], ",", "\<\",\"\>", ",", "\<\"Sumatoria[n-1]+\"\>", 
                    ",", 
                    RowBox[{
                    "VilCretas`Private`RS", "[", "VilCretas`Private`RVl18", 
                    "]"}], ",", "\<\"]\"\>"}], "]"}]}], "]"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], 
                    "]"}]}], "]"}]}], "]"}], "]"}]}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilCretas`Sumatoria\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Construye de manera autom\[AAcute]tica un programa \
recursivo para calcular una sumatoria ingresada por el usuario, la instrucci\
\[OAcute]n adem\[AAcute]s, facilita el c\[AAcute]lculo paso a paso para un \
valor de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] (\[IAcute]ndice \
superior de la suma) especificado como par\[AAcute]metro. Sintaxis: \
Sumatoria[suma], o bien, Sumatoria[suma, n], suma es un vector con tres \
componentes en el siguiente orden: el \[IAcute]ndice inferior, el \
\[IAcute]ndice superior (en funci\[OAcute]n de \[OpenCurlyDoubleQuote]n\
\[CloseCurlyDoubleQuote]) y la expresi\[OAcute]n interna de la sumatoria (en \
funci\[OAcute]n de \[OpenCurlyDoubleQuote]i\[CloseCurlyDoubleQuote]).\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{22.5, {7., 15.5}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{22.5, {7., 15.5}}]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[
   Association[
   "ObjectType" -> "Symbol", "Usage" -> 
    "Construye de manera autom\[AAcute]tica un programa recursivo para \
calcular una sumatoria ingresada por el usuario, la instrucci\[OAcute]n adem\
\[AAcute]s, facilita el c\[AAcute]lculo paso a paso para un valor de \
\[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote] (\[IAcute]ndice superior de \
la suma) especificado como par\[AAcute]metro. Sintaxis: Sumatoria[suma], o \
bien, Sumatoria[suma, n], suma es un vector con tres componentes en el \
siguiente orden: el \[IAcute]ndice inferior, el \[IAcute]ndice superior (en \
funci\[OAcute]n de \[OpenCurlyDoubleQuote]n\[CloseCurlyDoubleQuote]) y la \
expresi\[OAcute]n interna de la sumatoria (en funci\[OAcute]n de \
\[OpenCurlyDoubleQuote]i\[CloseCurlyDoubleQuote]).", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilCretas`Sumatoria, {VilCretas`Sumatoria[
         Pattern[VilCretas`Private`Rsuma, 
          Blank[]], 
         Optional[
          Pattern[VilCretas`Private`Rn, 
           Blank[]], 
          Rational[1, 1000000000]]] :> 
       Module[{VilCretas`Private`FuncionVariable}, 
         VilCretas`Private`FuncionVariable[
            Pattern[VilCretas`Private`FuncionVariable, 
             Blank[List]]] := 
          Module[{VilCretas`Private`FuncionVariableAuxiliar, 
             VilCretas`Private`Simbolos, 
             VilCretas`Private`VariableAuxiliarSimbolos, 
             VilCretas`Private`VariableAuxiliarVariables = {}}, 
            VilCretas`Private`FuncionVariableAuxiliar[] := 
             Part[VilCretas`Private`FuncionVariable, 1]; 
            VilCretas`Private`Simbolos[
               Pattern[VilCretas`Private`VariableFuncion, 
                Blank[]]] := DeleteDuplicates[
               Cases[
                DownValues[VilCretas`Private`VariableFuncion], 
                Blank[Symbol], Infinity]]; 
            VilCretas`Private`VariableAuxiliarSimbolos = Sort[
               VilCretas`Private`Simbolos[
               VilCretas`Private`FuncionVariableAuxiliar]]; 
            For[VilCretas`Private`VariableFuncioni = 1, 
              VilCretas`Private`VariableFuncioni <= 
              Length[VilCretas`Private`VariableAuxiliarSimbolos], If[NumericQ[
                  Part[
                  VilCretas`Private`VariableAuxiliarSimbolos, 
                   VilCretas`Private`VariableFuncioni]] == False, 
                VilCretas`Private`VariableAuxiliarVariables = 
                Append[VilCretas`Private`VariableAuxiliarVariables, 
                  Part[
                  VilCretas`Private`VariableAuxiliarSimbolos, 
                   VilCretas`Private`VariableFuncioni]]]; 
              Increment[VilCretas`Private`VariableFuncioni]]; 
            VilCretas`Private`VariableAuxiliarVariables]; Quiet[
           If[
            VectorQ[VilCretas`Private`Rsuma], 
            If[MemberQ[VilCretas`Private`Rsuma, Null] == False, 
             If[
             Length[VilCretas`Private`Rsuma] == 3, 
              Clear[$CellContext`n, $CellContext`i]; If[
                And[
                 IntegerQ[
                  Part[VilCretas`Private`Rsuma, 1]], ToString[
                   VilCretas`Private`FuncionVariable[{
                    Part[VilCretas`Private`Rsuma, 2]}]] == "{n}", 
                 Or[
                  StringContainsQ[
                   ToString[
                    Part[VilCretas`Private`Rsuma, 3]], "i"], 
                  NumericQ[
                   Part[VilCretas`Private`Rsuma, 3]]]], 
                If[
                 PolynomialQ[
                  Part[VilCretas`Private`Rsuma, 2], $CellContext`n], 
                 If[Exponent[
                    Part[VilCretas`Private`Rsuma, 2], $CellContext`n] == 1, 
                  If[Coefficient[
                    Part[VilCretas`Private`Rsuma, 2], $CellContext`n] == 1, 
                   If[
                    NumericQ[VilCretas`Private`Rn], 
                    
                    Module[{
                    VilCretas`Private`RS, VilCretas`Private`RIS, 
                    VilCretas`Private`RSumatoria, 
                    VilCretas`Private`RSumatoriaSteps}, 
                    VilCretas`Private`RVl17 = $CellContext`i; 
                    VilCretas`Private`RVl18 = Part[
                    Variables[
                    Part[VilCretas`Private`Rsuma, 2]], 1]; 
                    VilCretas`Private`RIS[
                    Pattern[VilCretas`Private`Ri, 
                    Blank[]]] := ReplaceAll[
                    Together[
                    Expand[
                    Part[VilCretas`Private`Rsuma, 2]]], 
                    VilCretas`Private`RVl18 -> VilCretas`Private`Ri]; 
                    VilCretas`Private`RS[
                    Pattern[VilCretas`Private`Ri, 
                    Blank[]]] := ReplaceAll[
                    Together[
                    Expand[
                    Part[VilCretas`Private`Rsuma, 3]]], 
                    VilCretas`Private`RVl17 -> 
                    VilCretas`Private`RIS[VilCretas`Private`Ri]]; 
                    VilCretas`Private`RVl19 = 
                    ReplaceAll[VilCretas`Private`RVl18, 
                    Part[
                    Flatten[
                    Solve[
                    Part[VilCretas`Private`Rsuma, 2] == 
                    Part[VilCretas`Private`Rsuma, 1]]], 1]]; If[
                    IntegerQ[VilCretas`Private`Rn], 
                    If[
                    VilCretas`Private`Rn >= VilCretas`Private`RVl19, 
                    VilCretas`Private`RSumatoria[
                    Pattern[VilCretas`Private`Rm, 
                    Blank[]]] := 
                    If[VilCretas`Private`Rm == VilCretas`Private`RVl19, 
                    VilCretas`Private`RS[VilCretas`Private`RVl19], 
                    VilCretas`Private`RSumatoria[VilCretas`Private`Rm - 1] + 
                    VilCretas`Private`RS[VilCretas`Private`Rm]]; 
                    VilCretas`Private`RSumatoriaSteps[
                    Pattern[VilCretas`Private`Rm, 
                    Blank[]]] := 
                    If[VilCretas`Private`Rm == VilCretas`Private`RVl19, 
                    Print["Sumatoria[", VilCretas`Private`RVl19, "] = ", 
                    VilCretas`Private`RS[VilCretas`Private`RVl19]], 
                    Print["Sumatoria[", VilCretas`Private`Rm, 
                    "] = Sumatoria[", VilCretas`Private`Rm - 1, "] + ", 
                    VilCretas`Private`RS[VilCretas`Private`Rm], " = ", 
                    VilCretas`Private`RSumatoria[VilCretas`Private`Rm]]; 
                    VilCretas`Private`RSumatoriaSteps[
                    VilCretas`Private`Rm - 1] + 
                    VilCretas`Private`RS[VilCretas`Private`Rm]; 
                    VilCretas`Private`RSumatoria[VilCretas`Private`Rm]]; 
                    Print["Sumatoria[n_]:=If[n\[Equal]", 
                    VilCretas`Private`RVl19, ",", 
                    VilCretas`Private`RS[VilCretas`Private`RVl19], ",", 
                    "Sumatoria[n-1]+", 
                    VilCretas`Private`RS[VilCretas`Private`RVl18], "]"]; 
                    VilCretas`Private`RSumatoriaSteps[VilCretas`Private`Rn]], 
                    If[VilCretas`Private`Rn == 1/1000000000, 
                    Print[
                    "Sumatoria[n_]:=If[n\[Equal]", VilCretas`Private`RVl19, 
                    ",", 
                    VilCretas`Private`RS[VilCretas`Private`RVl19], ",", 
                    "Sumatoria[n-1]+", 
                    VilCretas`Private`RS[VilCretas`Private`RVl18], 
                    "]"]]]]]]]]]]]]]]}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "VilCretas`Sumatoria"], 
   False]]], "Output",
 CellChangeTimes->{3.8051185419707108`*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"b1acc851-b053-47ff-984a-a3ec4efad48f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sumatoria", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"n", "-", "10"}], ",", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"2", ",", "i"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", "1"}], ")"}]}]}], "}"}], ",", "20"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.805118330149394*^9, 3.805118333547718*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"865324de-65aa-45b6-8930-b36c0eaf9ef9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[n_]:=If[n\[Equal]\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\",\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "5", "]"}], 
    RowBox[{"26", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\",\"\>", 
   "\[InvisibleSpace]", "\<\"Sumatoria[n-1]+\"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"-", "10"}], "+", "n"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10"}], "+", "n"}], ")"}], "2"]}], ")"}], " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\"]\"\>"}],
  SequenceForm[
  "Sumatoria[n_]:=If[n\[Equal]", 15, ",", Rational[1, 26] Log[2]^(-1) Log[5], 
   ",", "Sumatoria[n-1]+", (1 + (-10 + $CellContext`n)^2)^(-1) Log[2]^(-1) 
   Log[-10 + $CellContext`n], "]"],
  Editable->False]], "Print",
 CellChangeTimes->{3.805118334010433*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"10849886-85ed-45db-9d33-7006d48970d1"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "20", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "10", "]"}], 
    RowBox[{"101", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "5", "]"}], 
     RowBox[{"26", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "6", "]"}], 
     RowBox[{"37", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "7", "]"}], 
     RowBox[{"50", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "8", "]"}], 
     RowBox[{"65", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "9", "]"}], 
     RowBox[{"82", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "10", "]"}], 
     RowBox[{"101", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}]}],
  SequenceForm[
  "Sumatoria[", 20, "] = Sumatoria[", 19, "] + ", Rational[1, 101] 
   Log[2]^(-1) Log[10], " = ", Rational[1, 26] Log[2]^(-1) Log[5] + 
   Rational[1, 37] Log[2]^(-1) Log[6] + Rational[1, 50] Log[2]^(-1) Log[7] + 
   Rational[1, 65] Log[2]^(-1) Log[8] + Rational[1, 82] Log[2]^(-1) Log[9] + 
   Rational[1, 101] Log[2]^(-1) Log[10]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"5c10a933-8357-4d3b-b8b9-c6e8812602e8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "19", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "9", "]"}], 
    RowBox[{"82", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "5", "]"}], 
     RowBox[{"26", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "6", "]"}], 
     RowBox[{"37", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "7", "]"}], 
     RowBox[{"50", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "8", "]"}], 
     RowBox[{"65", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "9", "]"}], 
     RowBox[{"82", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}]}],
  SequenceForm[
  "Sumatoria[", 19, "] = Sumatoria[", 18, "] + ", Rational[1, 82] Log[2]^(-1) 
   Log[9], " = ", Rational[1, 26] Log[2]^(-1) Log[5] + 
   Rational[1, 37] Log[2]^(-1) Log[6] + Rational[1, 50] Log[2]^(-1) Log[7] + 
   Rational[1, 65] Log[2]^(-1) Log[8] + Rational[1, 82] Log[2]^(-1) Log[9]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"669efff0-751e-40cc-97d6-0dfdf55e1683"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "18", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "8", "]"}], 
    RowBox[{"65", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "5", "]"}], 
     RowBox[{"26", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "6", "]"}], 
     RowBox[{"37", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "7", "]"}], 
     RowBox[{"50", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "8", "]"}], 
     RowBox[{"65", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}]}],
  SequenceForm[
  "Sumatoria[", 18, "] = Sumatoria[", 17, "] + ", Rational[1, 65] Log[2]^(-1) 
   Log[8], " = ", Rational[1, 26] Log[2]^(-1) Log[5] + 
   Rational[1, 37] Log[2]^(-1) Log[6] + Rational[1, 50] Log[2]^(-1) Log[7] + 
   Rational[1, 65] Log[2]^(-1) Log[8]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"76d6fe89-33b4-448c-9067-cb82308b5fee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "17", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "7", "]"}], 
    RowBox[{"50", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "5", "]"}], 
     RowBox[{"26", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "6", "]"}], 
     RowBox[{"37", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "7", "]"}], 
     RowBox[{"50", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}]}],
  SequenceForm[
  "Sumatoria[", 17, "] = Sumatoria[", 16, "] + ", Rational[1, 50] Log[2]^(-1) 
   Log[7], " = ", Rational[1, 26] Log[2]^(-1) Log[5] + 
   Rational[1, 37] Log[2]^(-1) Log[6] + Rational[1, 50] Log[2]^(-1) Log[7]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"038c3e4d-aded-496f-ab12-4cea9c40c0cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "16", 
   "\[InvisibleSpace]", "\<\"] = Sumatoria[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] + \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "6", "]"}], 
    RowBox[{"37", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", "5", "]"}], 
     RowBox[{"26", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]], "+", 
    FractionBox[
     RowBox[{"Log", "[", "6", "]"}], 
     RowBox[{"37", " ", 
      RowBox[{"Log", "[", "2", "]"}]}]]}]}],
  SequenceForm[
  "Sumatoria[", 16, "] = Sumatoria[", 15, "] + ", Rational[1, 37] Log[2]^(-1) 
   Log[6], " = ", Rational[1, 26] Log[2]^(-1) Log[5] + 
   Rational[1, 37] Log[2]^(-1) Log[6]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"79d3a2e2-d3f7-4f77-86e3-4fa3fe3858c9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sumatoria[\"\>", "\[InvisibleSpace]", "15", 
   "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
   FractionBox[
    RowBox[{"Log", "[", "5", "]"}], 
    RowBox[{"26", " ", 
     RowBox[{"Log", "[", "2", "]"}]}]]}],
  SequenceForm["Sumatoria[", 15, "] = ", Rational[1, 26] Log[2]^(-1) Log[5]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[3]:=",ExpressionUUID->"acd5772d-f256-4d64-853c-33e3d698b370"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Log", "[", "5", "]"}], 
   RowBox[{"26", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "6", "]"}], 
   RowBox[{"37", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "7", "]"}], 
   RowBox[{"50", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "8", "]"}], 
   RowBox[{"65", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "9", "]"}], 
   RowBox[{"82", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "10", "]"}], 
   RowBox[{"101", " ", 
    RowBox[{"Log", "[", "2", "]"}]}]]}]], "Output",
 CellChangeTimes->{3.8051183340144415`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"5e4ed5ff-fd1c-45d8-a0bd-4a1990952ec0"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{Automatic, -5.5}, {-5.5, Automatic}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"134993e5-4dfd-475a-8c0c-e90d5d012514"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 202, 3, 63, "Input",ExpressionUUID->"a44b58f6-8155-4e6f-892f-8d8a0cd9f2e8"],
Cell[CellGroupData[{
Cell[785, 27, 457, 12, 97, "Input",ExpressionUUID->"ccd2e7f3-100a-47b3-9ca8-02c3008d5b0d"],
Cell[1245, 41, 1160, 29, 162, "Print",ExpressionUUID->"d7903703-cc5f-409a-b9f8-fd6470b0e961"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2442, 75, 200, 3, 63, "Input",ExpressionUUID->"44373834-2856-46ff-bc47-2ce94abff308"],
Cell[2645, 80, 33409, 713, 753, "Output",ExpressionUUID->"b1acc851-b053-47ff-984a-a3ec4efad48f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36091, 798, 491, 14, 145, "Input",ExpressionUUID->"865324de-65aa-45b6-8930-b36c0eaf9ef9"],
Cell[CellGroupData[{
Cell[36607, 816, 1158, 29, 162, "Print",ExpressionUUID->"10849886-85ed-45db-9d33-7006d48970d1"],
Cell[37768, 847, 1729, 45, 196, "Print",ExpressionUUID->"5c10a933-8357-4d3b-b8b9-c6e8812602e8"],
Cell[39500, 894, 1553, 40, 196, "Print",ExpressionUUID->"669efff0-751e-40cc-97d6-0dfdf55e1683"],
Cell[41056, 936, 1389, 36, 154, "Print",ExpressionUUID->"76d6fe89-33b4-448c-9067-cb82308b5fee"],
Cell[42448, 974, 1221, 31, 121, "Print",ExpressionUUID->"038c3e4d-aded-496f-ab12-4cea9c40c0cc"],
Cell[43672, 1007, 1057, 27, 121, "Print",ExpressionUUID->"79d3a2e2-d3f7-4f77-86e3-4fa3fe3858c9"],
Cell[44732, 1036, 542, 13, 79, "Print",ExpressionUUID->"acd5772d-f256-4d64-853c-33e3d698b370"]
}, Open  ]],
Cell[45289, 1052, 868, 27, 211, "Output",ExpressionUUID->"5e4ed5ff-fd1c-45d8-a0bd-4a1990952ec0"]
}, Open  ]]
}
]
*)

