(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25708,        551]
NotebookOptionsPosition[     24425,        520]
NotebookOutlinePosition[     24859,        537]
CellTagsIndexPosition[     24816,        534]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.80968683738245*^9, 3.809686844931754*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"a2dcb77e-7e55-46ae-9380-bfbea0e0879a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraficaRelBin", "[", 
  RowBox[{"\"\<a^2/25-b^2/4==1\>\"", ",", "15", ",", "5", ",", 
   RowBox[{"xmin", "\[Rule]", 
    RowBox[{"-", "15"}]}], ",", 
   RowBox[{"ymin", "\[Rule]", 
    RowBox[{"-", "5"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.809687628391791*^9, 3.809687716769989*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"0f5e34e0-710c-42de-a880-e3214c67dacb"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxdmAdUVWcSxwERsSHwHqAgyFPwAYJYsvbNnVgodo0xHoMFVNZGUbEnuNiJ
HZ+KYi+rRNesgogKfhMwgkZDsYSmIcXeBVEWhcCd+XaP9517Dod37/vKfDP/
/2+uISxq9DQLMzMzV3Mzs4a/w8OfDgt/6gNm6kcPV0KGdx97xwdK/I+a4l/r
YLNHcILHFR9oEdvol3vlOtDtN+34frkP1H8bnHBYBxUWbeOvTvOBmj7/SJy8
rv759Zsqmrb2gYbbHsE6mFWaFlGa5g2x7Zec+eO1PZS1XiF6LvSGlfMnDUjL
sIe8hNjc0EHe4KkOaA8B6rheYG7Z8LGHn27W9M6K94LU7VU47JkdXF88Kt+m
3AgZp4eHzxpnB07flLnfPmyEweqEdvA0M7QkYI8RIgfuWvKpqx20V8c1wuUX
C/pn29vBm7rKpZdOdYSeLeZ3jx9qC91X2Oyb2Lgj3G1YZkQrmO97qNmuHE+Y
GtUx8M4bGyhWv/eE8YVlfeIH20BE37pxNXc9IDTR85vEkS3B6q1dWWC0BxjV
eVrAvqI//I3vOsD0k5GjXx5rTvEL7gBpnsM/7P2qGdxJvzdhpq4DNJ3Vd2Js
bVNY3Td5Zd9H7SFajVNTcNZnlXXo2h6+7NynNnukNWRHNz49wbE9pDw51b/Q
1RoKzq2qnRdpgHMNyyq1glbNKq8EjTKA5c+Xz+Tts4JANQ4GOGlXvHb2QCuo
GW0cczHVnffXGM6E/eB/KcYdLpmKDdMfW1J87N0h9ELUoSB3S1jnlHt4kbk7
WKj5YAnRyvjIzF7tYNI/I9Pi/BvB+7qGjyus2VMUv6fIHGY92hCqT3AF86Eu
1iUR5hAUMzAwZqArDFHXYQ49b3fdeWNQW+jdv0dTU02dkjfBrN2Rty4w1fDg
iFNQnZKi7sMFXKMtjNEWdcrRkKtHQq46g5caz/fKhzR3iy6znMEm7/uJRQdq
lJlqnNpAkmsn24CSauXrvQ8W7z3aBuao31crDnNvLnm3ow0cr15788SGaiXu
cNi5rRWtYXdo1ajrv75VQnbrkptvbA3n1XmrFLf+w38JgdZw0dBj3ucVb5TE
7Sl/n5noBAcy4gy+1pVKB2jpt3ObEzRS41Gp2PzbVH85wVzP0a757ysUg7pO
J/hMVA4RlRXKk2tOrRy/c4Sh6v5fKW0NK06+GusI6ydOm9St9IVS2uz+wRij
I3T3vrEhMe65cmP5w11T7jmAjzrOU2XzncoDkOsApvU3M4v3P1GCv67a57bB
AWLU/T1SitRzdIAkc1O6uemhsr48LWt0oAOsrc16d/2zB8rRlMSfw/o4QKa6
v/uKe+Cqu4u9HaBwgLOY73lfqTg16Eub23pIqew9pjb9d+W3T5fXWJ/Uwwh1
vb8prXxHDpm/Sg+47fiWOXPvKH6WCbkbF+nheMcol+dVpUpqw7hf6WHpcr+i
+ktp8TdjXPpIPWSr891W2opH5W276aFT+XLdU7NCxW9gD/Miox7KUlNuzbPL
V/y9O916Za+HPPX5y0qLHy9Yd7HWg39BbO9+P2Uqw+KikgrM9fCfq1NXx+Wc
VO7nxQWMr9WxPuX2k/dfXlHvC/n7gnz190KOv4/GF3L+H2h+4cLrc6T1iea8
/uO0fiH3t5D2J3x5/9tp/8KG43OY4iP8K7r5V5zWwwCKn3jN8U2m+Ao3jn8W
xV9cSOlbfznAKTofsY7Pbxmdn9Ccrwji859O5y82cX6so/wQhZw/bpQ/opjz
y0D5JVw4/1ZQ/olHnJ8BlJ9Ck7+iJed3JOW3MHD+f1DrvkKYuD62U30IV66f
81Q/YjzXVyrVl9jotyE4/XVr8DfTPXhV/lbI+u2SlNI7KaVa1HB9N6f6Fke4
/km33wupD26kD+I668dk0g/RhfWlE+mLCGD9CSL9wRmsT3VDVH1CqV+rSb8w
ivVtAukbuuTMaZvzqh2oj9U1wlTWyyzSS5T6+nqKUjVFsUIb1l8L0l/MZ31O
I31GZP0+QfqNbVjfvyB9x5Ws/xGk/1jG/tCE/AE1/oF72V/CyV/Qkv3Hg/wH
Z7M/TSZ/Qo1/YQz7Wxj5G3Zl/ysl/0ONP6LrsZ0bX9yS921R+umNEUn9PXR2
+ORjv8Uxj0ckK0eMxAcedpjLfn2W/Bqvsp+nkJ+jxu/xOvMA7cceSz/mBdTw
BGp4AzU8ghpeQQ3PoIZ3sCCkyXHxfx5C5iOU/1+l57GUn0+g8dCGx9PTfCjn
q6T14HteD68X5XojaT8Yx/tx9i2c+sVCbzw1/daygxn/iwfKeAymeKElx+sa
xRPPcDwzKd54kuPtSHyE8jyYjzCKz4u4y4i5xEfy/LEXnz/nB8r8YD5C5iMs
o/zCyZxfkZR/OIXzj/MTZX7up/zFGZy/Wym/8QLn913Kf2Q+kvWBsj6Yj5D5
CM9TfeFBrq8zgbPrLwPK+rOl+kTmI4qfhwHfcf2mUX3jj1zfXP8o638O6QNO
Zn0gLnLD9awfs0lf0IL4B1l/UOqPkfQJnVifmH8wnPWLOM4F/VjfWP9Q6l8t
6SPasj4SJ7bBZOIfsZj4h+uiWmwmvcVPWG9Zj1HqcTvSaxSs15tJzzGe9Zz1
HqXetyI/wHnsB8S5TjiG/YL9BKWfMO/gJvabW+RH2IT9yOvbg17f/u6A0q+2
kJ/hDvYz4lQHvL5mafqapQ8F8w2uY3/8F/ENSv/sF5vskunlgGPjPMNiO9wX
5cQzKP141aLvXP5coMeyqTvOFNSVit2fzC3MDdaj9PukF6vb3fLU4/OAs9fO
WeWLEtP0zw+21KPkh+TaPYdSrfQIlv+tKX6cKXZNmha7rVqHGh7BE8QjSkvi
ETzGPCPHk7zDPILpzEPMSxjEvLSH1yd5qjPxB+YwfzF/4E7mM+Y3lPxWSfyB
yHzH/IEZzH8ZxB8o+fB5xJ+9o+vj+6hk77Rl9fwo45/PfMn8iZI/E/i89jOf
3iT+QMmvRXzezsy3bpwPicy/zMco+fh0Qtnjsy8d8WGJ4/bamleKJr8UW86/
hczbzOMoeXwr56+Jed2d8zubeZ55HyXvb+H66EX1IfsHlP2Dpr6UOq4/Pfcf
3J+g7E9k/fpy/1LA9T2D+5vOXP+e3P9wf4SyP4pg/bDk/knqywbur+ax/oRy
/8X9Gcr+rCP1bzid+7ezrGc53N9p9A6kHlpxv3iW9VL2kxdZT5O533RhvR3H
/Sj3qyj71V9Zr5tzP6vRczjAej+L+2Hul1H2y9IvpnI/rfETWMB+E879OPfr
KPv1qo/9CjR+Bs8+9jv5vgDl+4Js9ssUfp8w9IP3m6MxXpiuxsMOzKDJp3n1
/mo6vFM36JkdSP9tzO8n+P0FyvcXLuzfp8m/QePvoPF/0PABaPgBNHwBGv4A
5hXJJ/AXTrBE3w==
    "], {{}, {}, 
     TagBox[
      TooltipBox[
       {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146}], LineBox[CompressedData["
1:eJwN0dciFQAAANB7kVVKVoQHv+QTfAAf4jEjlS0rM2WPFkpmKrPsRGYksjoP
5wtORlZOZnYwEAjk8oA88imgkIcU8YjHPKGYEkopo5wKKqniKdXUUEsd9Tyj
gUaaaKaFVp7Txgte0k4HnXTRTQ+99NHPAK94zRve8o5BhhjmPR8Y4SOjjDHO
BJNM8YlpPvOFr8wwyxzzLLDIN76zxDIrrLLGOhv8YJOfbLHNL3bYZY99Djjk
N0cc84cT/nLKGf8454JLrrgmIC9ICKGEcYNwIogkimhucosYbnOHWO4SRzwJ
JJLEPZJJ4T6ppJHOf1zvWaU=
         "]]},
       RowBox[{
         RowBox[{
           FractionBox[
            SuperscriptBox[
             TagBox["VilCretas`Private`RBVl4$24821", HoldForm], "2"], "25"], 
           "-", 
           FractionBox[
            SuperscriptBox[
             TagBox["VilCretas`Private`RBVl5$24821", HoldForm], "2"], "4"]}], 
         "\[Equal]", "1"}]],
      Annotation[#, 
       Rational[1, 25] HoldForm[VilCretas`Private`RBVl4$24821]^2 + 
        Rational[-1, 4] HoldForm[VilCretas`Private`RBVl5$24821]^2 == 1, 
       "Tooltip"]& ]}], {}},
  AspectRatio->1,
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "GridLinesInFront" -> 
    True},
  PlotRange->{{-15, 15}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.8096876701276755`*^9, 3.8096877175858154`*^9}, 
   3.809691874641693*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"01bc0170-b2a7-4dc8-b675-68c2d870df65"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraficaRelBin", "[", 
  RowBox[{"\"\<a^2/25-b^2/4>=1\>\"", ",", "15", ",", "5", ",", 
   RowBox[{"xmin", "\[Rule]", 
    RowBox[{"-", "15"}]}], ",", 
   RowBox[{"ymin", "\[Rule]", 
    RowBox[{"-", "5"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.809689037285715*^9, 3.8096890423260946`*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"2fd7ad67-3755-4dc2-9c27-7836e9ac2f0b"],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxlmXlwlEUWwIMchiPkIAkkQoAQknCjSaiImOkYtLwWIwpymSCHqGEhCiqj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    "], {
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      0.3], EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmcz+UWx5/nkaSiFMYSRoVIljYkJdlSIrJLGEloLCUkzJCxJEsYYcZ+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         "]], PolygonBox[CompressedData["
1:eJwtlnm0lmMUxd/nVDSqW2qVclWSRIokKZSKUt10u0QS69KSyBUhLZkSZWYt
M5nKdBUZwpXGtRpkhZYMDVIpDVIoTYrfXvv9Y6+z9/O83/e933PO2edpVlpW
fENkWTYZVAbfpSyrwsJ6eAb/GeiBtsTzWBoALwb10F+gu8O3wZfAt4Cj0XPB
ONa+Rv9DbIHeAa8BPwo+B4yFf8XaxfCLQEN0I9AK/j1xPnt/g2roh8H5rPUG
H4Fy9BBiGftHwJ8AfdD9QEv4MuLn7P0F1sI7sxbEduBbMBM9iljA/kriNehW
xDboX4ij0KcS24MS+EBQH94AbAC3oDsSzwA/gmHoFsTjQAafDybAK5CbiUei
f4OfDf8JVEf/im4JrwR/AwyGz2btUvgloDG6CVgK9oJV7O0DG+EnsL8LvhB0
gK9gbV7mnP0ObxjORRX4ITAVPYg4i7V+8ImgO3olui58GhiKXpT53f+D18n8
Hxqg3weleY4/JU5HX0mciH4G/gIYgN6Gfgn+KihB71QJwSvAmPw7FxDfAWsz
19Bb4PhwrqqD/vALQV3WV6ML4R+CEehv0O3g++Br4P8K8M9YG02shj5Z56m6
he8H96DHg26sLUPvJO4Cy+GHq4bBB+wPJ05hrQ781nBu+2sPDA7nopT9GcRB
4VotQbeFT4XXBgfQtdE3hWunCMxRzaJHEt9l/0x4DbAxc002UW2H36Wctfbw
cvg6+CEwCz6DtWHKI/oT4hXoZsRJ6MWqdbAVvhssgn8MNmWukSXwuWC7ehH0
1mfBHzpv1uvBzwGVkmu0L7wN2KveynOld9K7KGd70F+CPfAVOsNwz6pXN6hn
k39Tv6Uz3q++YP/PzDmbhj5NNZa5xw/IB8DBzDl7MznHyq16+JRwjpVbPfN6
co6VW/XEA+EeUW+optULj4a9Qj2hd52n2svfeXvymemslsrzwp6X5Wf+fLiH
1Duq6WPDZ6azkoe9p75Hp+Qe7hruIfWOzrA+fCuxMtjMWmv0iWG+GLwS9kR5
oXqkKXq3/l+eox+Ip4fPcgHoA78A1GS9FngR3gMcBi8GvcI1ptqqSmyuXkrm
yvG94c/o2W752T8EeibnQN/1rHou+TtvhJeFvV6eXBT2DHlFAXohGIIu1LOs
3S0vCHt51+RZIc+V12pm6CzGqcbyM6kZ9lR5qXrgOvj14CR0z8xevEoel+zJ
16KnJ3tza+Lw8BnpbPTMCPQa7Sd/h7x6dfKz8mx5szxXXiuPvhN9Rzj3eqfL
wx4tb24KCtCbiF3yHhor74afBTqD28OeIC/oRBwa/g59Vj15mbw9ea8w7827
wmejHh0Dvy08uzRD5PXriR2SPV+1MIG1c/Oa0Cxap7wlz6T70feFe0/PjA57
krxI3/E0+qmwN+ud9V/0Hzrn/+nBsMfKW3sk18JVoHlyTXQKz1TNUtW4Zmst
0Dd5xt4c9sj++Ttpdr2dPEs1w0aGPbAoz4m8P8J3Bc2AR+AdlW90L/ST8C7h
3Os3Xg7PEM2OgejH4I+HZ6s+o16YHN5TTzwXnkGaPaphzTrNFM0Szbyr0aXh
2ar/qFlxMHk2a2boriIPlvfqziKvbRyeFfJczYYdyXcZzQjdRaqG3113Ennl
a8m9Ic+U100Kn608T3eN5cmzV3cOzbLZyV6umabZcEx4tmlG6G7UKDyLdEfS
7K1I9nrNYM3eLcleohms2T0z70XNcN2NdEfQ3UB3pCnJM0qzSTP1f4XCOsI=

         "]]}]}, {}, {}, {}, {}}], {}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{Automatic, Automatic},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None, "TransparentPolygonMesh" -> True, "AxesInFront" -> True},
  PlotRange->{{-15, 15}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.80968904349899*^9, 3.8096890600114307`*^9}, 
   3.8096918779196014`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"3b571d32-3361-4cd7-8618-4f7f0f811f9b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementRelBinQ", "[", 
  RowBox[{"\"\<a^2/25-b^2/4>=1\>\"", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", 
      SqrtBox["7"]}], ",", 
     RowBox[{
      FractionBox["2", "5"], 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"expalgebra", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8096907717316227`*^9, 3.8096908138359604`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"68ba5290-68ac-46f9-afaf-fa1b410f2ab0"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.809690814591032*^9, 3.809691881481919*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"c6e2ddcd-fd56-462a-bfe3-3bc466c1ae6e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", 
        SqrtBox["2"]}], ",", 
       RowBox[{"2", 
        SqrtBox["3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", 
        SqrtBox["7"]}], ",", 
       RowBox[{
        FractionBox["2", "5"], 
        SqrtBox["3"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SqrtBox["2"], ",", 
       FractionBox[
        RowBox[{"6", 
         SqrtBox["3"]}], "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", 
       FractionBox[
        RowBox[{"2", 
         SqrtBox["11"]}], "5"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"5", 
        SqrtBox["3"]}], ",", 
       RowBox[{
        RowBox[{"-", "2"}], 
        SqrtBox["2"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["1", "25"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"7", 
        SqrtBox["7"]}], ",", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", 
          SqrtBox["318"]}], "5"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["11", "2"], ",", 
       RowBox[{"-", 
        FractionBox[
         SqrtBox["21"], "5"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       FractionBox[
        RowBox[{"2", 
         SqrtBox["34"]}], "5"]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ElementRelBinQ", "[", 
    RowBox[{"\"\<a^2/25-b^2/4>=1\>\"", ",", "punto", ",", 
     RowBox[{"expalgebra", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"punto", ",", "L"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8096868635234375`*^9, 3.809687060482098*^9}, {
  3.8096912230497074`*^9, 3.8096912615912275`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"55671955-beaf-46c2-8ec0-aabf7c5e442c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "True", ",", "True", ",", "False", ",", "True", ",", "True", 
   ",", "False", ",", "True", ",", "True", ",", "False"}], "}"}]], "Output",
 CellChangeTimes->{3.809691262364029*^9, 3.8096918847005672`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"4b958dae-1f68-4fad-9026-f480ed14e8e8"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6514ece5-054f-4dc5-8db8-b6f70ddffdfd"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 198, 3, 91, "Input",ExpressionUUID->"a2dcb77e-7e55-46ae-9380-bfbea0e0879a"],
Cell[CellGroupData[{
Cell[781, 27, 394, 8, 135, "Input",ExpressionUUID->"0f5e34e0-710c-42de-a880-e3214c67dacb"],
Cell[1178, 37, 6353, 124, 739, "Output",ExpressionUUID->"01bc0170-b2a7-4dc8-b675-68c2d870df65"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7568, 166, 396, 8, 135, "Input",ExpressionUUID->"2fd7ad67-3755-4dc2-9c27-7836e9ac2f0b"],
Cell[7967, 176, 13295, 233, 739, "Output",ExpressionUUID->"3b571d32-3361-4cd7-8618-4f7f0f811f9b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21299, 414, 461, 12, 226, "Input",ExpressionUUID->"68ba5290-68ac-46f9-afaf-fa1b410f2ab0"],
Cell[21763, 428, 174, 2, 107, "Output",ExpressionUUID->"c6e2ddcd-fd56-462a-bfe3-3bc466c1ae6e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21974, 435, 2093, 74, 585, "Input",ExpressionUUID->"55671955-beaf-46c2-8ec0-aabf7c5e442c"],
Cell[24070, 511, 339, 6, 151, "Output",ExpressionUUID->"4b958dae-1f68-4fad-9026-f480ed14e8e8"]
}, Open  ]]
}
]
*)

