(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15438,        399]
NotebookOptionsPosition[     13998,        368]
NotebookOutlinePosition[     14432,        385]
CellTagsIndexPosition[     14389,        382]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"<<", "VilCretas`"}]], "Input",
 CellChangeTimes->{{3.8101277929471655`*^9, 3.810127796453377*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"a968e5b7-dfe3-4863-a089-9c21280a322b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"MR1", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0", "0", "0"},
      {"1", "1", "0", "0"},
      {"1", "0", "1", "1"},
      {"0", "1", "0", "0"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MR2", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", "1", "0"},
      {"0", "1", "0", "1"},
      {"1", "0", "1", "0"},
      {"1", "0", "1", "1"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"UnionBooleana", "[", 
     RowBox[{"MR1", ",", "MR2"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "A", ",", "A"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"InterseccionBooleana", "[", 
     RowBox[{"MR1", ",", "MR2"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "A", ",", "A"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ComplementoBooleano", "[", "MR1", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "A", ",", "A"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "MR1", "]"}], ",", "A", ",", "A"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"RelBinMatriz", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ProductoBooleano", "[", 
     RowBox[{"MR2", ",", "MR1"}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", "A", ",", "A"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8101276532388954`*^9, 3.8101278412958403`*^9}, {
  3.8101283776330943`*^9, 3.8101284255596943`*^9}, {3.8101461603073792`*^9, 
  3.8101461679724646`*^9}, {3.810146241594352*^9, 3.810146244021372*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"56793b18-6cd6-43c9-90c2-9d3e163dd4d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.810127843032463*^9, 3.810128397503866*^9, 3.8101284312817492`*^9, 
   3.810131509809247*^9, 3.810146138257903*^9, 3.8101461701188416`*^9, {
   3.8101462450476255`*^9, 3.8101462520487976`*^9}},
 CellLabel->"Out[37]=",ExpressionUUID->"1e937530-b82d-446e-96c9-2f295113fffa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.810127843032463*^9, 3.810128397503866*^9, 3.8101284312817492`*^9, 
   3.810131509809247*^9, 3.810146138257903*^9, 3.8101461701188416`*^9, {
   3.8101462450476255`*^9, 3.8101462520527887`*^9}},
 CellLabel->"Out[38]=",ExpressionUUID->"9e3b7c1e-a0a8-40f9-8ca7-89a3e0210ee2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.810127843032463*^9, 3.810128397503866*^9, 3.8101284312817492`*^9, 
   3.810131509809247*^9, 3.810146138257903*^9, 3.8101461701188416`*^9, {
   3.8101462450476255`*^9, 3.810146252055781*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"03410714-1379-4c32-bcc7-669ede599c27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.810127843032463*^9, 3.810128397503866*^9, 3.8101284312817492`*^9, 
   3.810131509809247*^9, 3.810146138257903*^9, 3.8101461701188416`*^9, {
   3.8101462450476255`*^9, 3.8101462520577736`*^9}},
 CellLabel->"Out[40]=",ExpressionUUID->"046b7761-b301-4e71-91a9-182356e591ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "d"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.810127843032463*^9, 3.810128397503866*^9, 3.8101284312817492`*^9, 
   3.810131509809247*^9, 3.810146138257903*^9, 3.8101461701188416`*^9, {
   3.8101462450476255`*^9, 3.810146252059769*^9}},
 CellLabel->"Out[41]=",ExpressionUUID->"648a7365-e916-4a05-bf95-df1e8f815c84"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnionBooleana", "[", 
   RowBox[{"MR1", ",", "MR2"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"ebf9a591-5628-44a4-b835-02cb384df883"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.810131513641121*^9, 3.8101461417071323`*^9, 
  3.8101462550491047`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"55bae336-9bab-40ce-8876-0e6a976acc35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Composicion", "=", 
   RowBox[{"RelBinMatriz", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ProductoBooleano", "[", 
       RowBox[{"MR2", ",", "MR1"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "A", ",", "A"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GrafoRelBin", "[", 
  RowBox[{"Composicion", ",", "A"}], "]"}]}], "Input",
 CellChangeTimes->{{3.8101461438053007`*^9, 3.8101461837444506`*^9}, {
  3.8101462146378684`*^9, 3.8101462338077164`*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"f96b974e-b760-4c2b-a447-65c027f2f380"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {
      SparseArray[
       Automatic, {4, 4}, 0, {
        1, {{0, 3, 5, 8, 12}, {{1}, {3}, {4}, {1}, {2}, {1}, {3}, {4}, {1}, {
          2}, {3}, {4}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}], Null}, {
      ImagePadding -> 10, 
       VertexLabels -> {
        3 -> $CellContext`c, 4 -> $CellContext`d, 2 -> $CellContext`b, 
         1 -> $CellContext`a}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[{{0.9405785829389705, 0.8755495650695511}, {
         0.7497362276922426, 0.9639018730270947}, {0.6932076842320137, 
         1.1627427862356423`}, {0.7520801435794142, 1.2899526066005762`}, {
         1.128525452410018, 1.2902030550189134`}, {1.187567124516684, 
         1.1630716827234056`}, {1.131303208017923, 0.9641557288846936}, {
         0.9405785829389705, 0.8755495650695511}},
         SplineDegree->7], 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0.9405785829389705, 0.8755495650695511}, {
         0.5423519618650691, 0.5017657228844568}, {0., 0.4373207706252032}}], 
         0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0.9405785829389705, 0.8755495650695511}, {
         1.0854912255315474`, 0.4380828188348672}, {0.9424518187723455, 0.}}],
          0.021651379769197815`], 
        ArrowBox[{{1.8825594104830379`, 0.4381919793319531}, {
         0.9405785829389705, 0.8755495650695511}}, 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{1.8825594104830379`, 0.4381919793319531}, {
         1.970896488835214, 0.6290413845333956}, {2.1697328904020368`, 
         0.6855857954269705}, {2.2969474084162957`, 0.6267234876800785}, {
         2.297227897374821, 0.2502782000340208}, {2.1701012370417474`, 
         0.19122638296249128`}, {1.971180793945169, 0.24747442568048464`}, {
         1.8825594104830379`, 0.4381919793319531}},
         SplineDegree->7], 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0., 0.4373207706252032}, {
         0.39822662107389906`, 0.8111046128102967}, {0.9405785829389705, 
         0.8755495650695511}}], 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0., 
         0.4373207706252032}, {-0.08833102446729907, 
         0.24646856342261317`}, {-0.2871656323165459, 
         0.18991784536545364`}, {-0.4143820174092157, 
         0.24877611777336223`}, {-0.41467444740404996`, 
         0.6252213963327793}, {-0.28754966028867757`, 
         0.6842772458970797}, {-0.08862743307558313, 0.6280355130652567}, {0.,
          0.4373207706252032}},
         SplineDegree->7], 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0., 0.4373207706252032}, {
         0.5431392636664776, 0.3736378665756119}, {0.9424518187723455, 0.}}], 
         0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0.9424518187723455, 0.}, {
         0.7975391761797691, 0.43746674623468235`}, {0.9405785829389705, 
         0.8755495650695511}}], 0.021651379769197815`], 
        ArrowBox[{{0.9424518187723455, 0.}, {1.8825594104830379`, 
         0.4381919793319531}}, 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0.9424518187723455, 0.}, {
         0.39931255510586866`, 0.06368290404959144}, {0., 
         0.4373207706252032}}], 0.021651379769197815`], 
        ArrowBox[BezierCurveBox[{{0.9424518187723455, 0.}, {
         1.1333110742311847`, -0.08831579407580792}, {
         1.1898776592184483`, -0.2871458885138049}, {
         1.131029538934872, -0.4143669701236534}, {
         0.7545842849101536, -0.41468944065612634`}, {
         0.6955182909065357, -0.2875693666345359}, {
         0.7517441494570432, -0.08864265193386417}, {0.9424518187723455, 0.}},
         SplineDegree->7], 0.021651379769197815`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9405785829389705, 0.8755495650695511}, 
          0.021651379769197815], 
         InsetBox["a", 
          Offset[{2, 2}, {0.9622299627081683, 0.8972009448387489}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8825594104830379, 0.4381919793319531}, 
          0.021651379769197815], 
         InsetBox["b", 
          Offset[{2, 2}, {1.9042107902522356, 0.45984335910115093}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.4373207706252032}, 0.021651379769197815], 
         InsetBox["c", 
          Offset[{2, 2}, {0.021651379769197815, 0.458972150394401}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9424518187723455, 0.}, 0.021651379769197815], 
         InsetBox["d", 
          Offset[{2, 2}, {0.9641031985415434, 0.021651379769197815}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImagePadding->10]], "Output",
 CellChangeTimes->{
  3.810146187521821*^9, {3.810146230568739*^9, 3.8101462867609787`*^9}},
 CellLabel->"Out[48]=",ExpressionUUID->"ee27f6b9-201b-4245-aea0-c9944cf55302"]
}, Open  ]]
},
WindowSize->{960, 478},
WindowMargins->{{-5.5, Automatic}, {Automatic, -5.5}},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 para Microsoft Windows (64-bit) (March 14, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a0a22b23-e342-40bc-855f-31d14d591efc"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 200, 3, 63, "Input",ExpressionUUID->"a968e5b7-dfe3-4863-a089-9c21280a322b"],
Cell[CellGroupData[{
Cell[783, 27, 1974, 55, 863, "Input",ExpressionUUID->"56793b18-6cd6-43c9-90c2-9d3e163dd4d6"],
Cell[2760, 84, 1057, 31, 144, "Output",ExpressionUUID->"1e937530-b82d-446e-96c9-2f295113fffa"],
Cell[3820, 117, 526, 13, 100, "Output",ExpressionUUID->"9e3b7c1e-a0a8-40f9-8ca7-89a3e0210ee2"],
Cell[4349, 132, 878, 25, 144, "Output",ExpressionUUID->"03410714-1379-4c32-bcc7-669ede599c27"],
Cell[5230, 159, 762, 21, 144, "Output",ExpressionUUID->"046b7761-b301-4e71-91a9-182356e591ff"],
Cell[5995, 182, 1055, 31, 144, "Output",ExpressionUUID->"648a7365-e916-4a05-bf95-df1e8f815c84"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7087, 218, 224, 5, 91, "Input",ExpressionUUID->"ebf9a591-5628-44a4-b835-02cb384df883"],
Cell[7314, 225, 541, 13, 144, "Output",ExpressionUUID->"55bae336-9bab-40ce-8876-0e6a976acc35"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7892, 243, 734, 19, 265, "Input",ExpressionUUID->"f96b974e-b760-4c2b-a447-65c027f2f380"],
Cell[8629, 264, 5353, 101, 524, "Output",ExpressionUUID->"ee27f6b9-201b-4245-aea0-c9944cf55302"]
}, Open  ]]
}
]
*)

