/*
 * Decompiled with CFR 0.152.
 */
package modelo;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import modelo.EventoActualizacion;
import modelo.simbolicos.ConjuntoReglas;
import modelo.simbolicos.DatosSimbolico;
import modelo.simbolicos.RelacionSimbolica;
import modelo.simbolicos.TIPO_DATO;
import modelo.sql.Conexion;
import vista.AdaptadorObservable;
import vista.IObservador;

public class GestorDatos
extends AdaptadorObservable {
    private static GestorDatos _instancia = null;
    private static Conexion conexion = null;
    private ConjuntoReglas reglas = new ConjuntoReglas();

    protected GestorDatos() {
    }

    public static GestorDatos Instancia() {
        if (_instancia == null) {
            _instancia = new GestorDatos();
        }
        return _instancia;
    }

    void Actualizar(Object e) {
        this.NotificarObservadores(new EventoActualizacion(e));
    }

    void Actualizar() {
        this.Actualizar(this);
    }

    @Override
    public void AgregarObservador(IObservador nuevoObservador) {
        super.AgregarObservador(nuevoObservador);
        this.Notificar(this, null);
    }

    public void agregarConcepto(String tabla, String columna, String rule) {
        this.reglas.agregarConcepto(tabla, columna, rule);
        this.Notificar(this, null);
    }

    public void agregarDatoSimbolico(String tabla, String columna, TIPO_DATO dato) {
        this.reglas.agregarDatoSimbolico(tabla, columna, dato);
        this.Notificar(this, null);
    }

    public DefaultTableModel obtenerDatosSimbolicos(String tabla) {
        RelacionSimbolica tablaSimbolics = this.reglas.getRelacion(tabla);
        if (tablaSimbolics != null) {
            Object[][] datos = new String[tablaSimbolics.getDatos().size() + tablaSimbolics.getConcepto().size()][3];
            int i = 0;
            for (String[] concepto : tablaSimbolics.getConcepto()) {
                datos[i][0] = concepto[0];
                datos[i][1] = "CONCEPT";
                datos[i][2] = concepto[1];
                ++i;
            }
            for (DatosSimbolico item : tablaSimbolics.getDatos()) {
                datos[i][0] = item.getColumna();
                datos[i][1] = item.getDato().toString();
                datos[i][2] = item.getRegla();
                ++i;
            }
            return new DefaultTableModel(datos, new String[]{"Variables", "Symbolic types", "Rule"});
        }
        return new DefaultTableModel((Object[][])null, new String[]{"Variables", "Symbolic types", "Rule"});
    }

    public void establecerConexion(String bd, String usuario, String clave, String server, String port) throws Exception {
        conexion = Conexion.getInstancia(bd, usuario, clave, server, port);
    }

    public String[] obtenerTablas() {
        return conexion.obtenerTablas();
    }

    public List<String[]> obtenerColumnas(String tabla) {
        return conexion.obtenerColumnas(tabla);
    }

    public TableModel obtenerTabla(String t1) {
        return conexion.obtenerDatos(t1);
    }

    public TableModel mostrarResultadoSimbolico(String tabla) {
        RelacionSimbolica rel = this.reglas.getRelacion(tabla);
        String rules = rel.recuperarReglas();
        if (rules.length() > 0) {
            conexion.prepararVistaSimbolica(tabla, rel.obtenerConcepto(), rules);
        } else {
            conexion.prepararVistaSimbolica(tabla, rel.obtenerConcepto());
        }
        String sql = rel.toString();
        return conexion.ejecutarSelect(sql);
    }

    public void removerDatoSimbolico(String tabla, String columna, TIPO_DATO datoPorEliminar) {
        RelacionSimbolica rel = this.reglas.getRelacion(tabla);
        if (datoPorEliminar == TIPO_DATO.CONCEPT) {
            rel.removerConcepto(columna);
        } else {
            rel.removerDato(columna, datoPorEliminar);
        }
        this.Actualizar();
    }

    public void guardarRegla(String tabla, String column, TIPO_DATO tipo, String regla) {
        RelacionSimbolica rel = this.reglas.getRelacion(tabla);
        rel.agregarRegla(column, tipo, regla);
        this.Actualizar();
    }

    public String obtenerRegla(String tabla, String columna, TIPO_DATO dato) {
        RelacionSimbolica rel = this.reglas.getRelacion(tabla);
        if (rel == null) {
            return "";
        }
        return rel.obtenerRegla(columna, dato);
    }

    public void conectar(String text, String text0, String text1, String server, String port) throws Exception {
        conexion = Conexion.getInstancia(text1, text, text0, server, port);
        this.Actualizar();
    }

    public boolean estaConectado() {
        return conexion.isEstaConectado();
    }

    public void crearRSDA(String tabla, String concept, String datos) {
        conexion.prepararTablaRSDA(tabla, concept, datos);
    }

    public RelacionSimbolica getRelacion(String tabla) {
        RelacionSimbolica rel = this.reglas.getRelacion(tabla);
        return rel;
    }

    public void guardarCSV(String tabla, String parent) throws Exception {
        conexion.guardarCSV(tabla, parent);
    }

    public void guardarTabla(String tablaSeleccionada, String a) throws Exception {
        conexion.guardarTabla(tablaSeleccionada, a);
        this.Actualizar();
    }
}

