/*
 * Decompiled with CFR 0.152.
 */
package modelo.simbolicos;

import modelo.simbolicos.TIPO_DATO;

public class DatosSimbolico {
    private String columna;
    private TIPO_DATO dato;
    private String rules = "";

    public DatosSimbolico(String columna, TIPO_DATO dato) {
        this.columna = columna;
        this.dato = dato;
    }

    public String getColumna() {
        return this.columna;
    }

    public void setColumna(String columna) {
        this.columna = columna;
    }

    public TIPO_DATO getDato() {
        return this.dato;
    }

    public void setDato(TIPO_DATO dato) {
        this.dato = dato;
    }

    public String getNombreDato() {
        switch (this.dato) {
            case CONTINUOUS: {
                return String.format("scon(%s)", this.columna);
            }
            case INTERVAL: {
                return String.format("sint(%s)", this.columna);
            }
            case HISTOGRAM: {
                return String.format("shis(%s)", this.columna);
            }
            case MODAL: {
                return String.format("sset(%s)", this.columna);
            }
            case MULTIVALUED_MODAL: {
                return String.format("shis(%s)", this.columna);
            }
        }
        return "";
    }

    public String toString() {
        switch (this.dato) {
            case CONTINUOUS: {
                return String.format("scon(%s) \"%s(continuous)\"", this.columna, this.columna);
            }
            case INTERVAL: {
                return String.format("sint(%s) \"%s(inverval)\"", this.columna, this.columna);
            }
            case HISTOGRAM: {
                return String.format("shis(%s) \"%s(histogram)\"", this.columna, this.columna);
            }
            case MODAL: {
                return String.format("sset(%s) \"%s(modal)\"", this.columna, this.columna);
            }
            case MULTIVALUED_MODAL: {
                return String.format("shis(%s) \"%s(multivalued modal)\"", this.columna, this.columna);
            }
        }
        return "";
    }

    public void setRegla(String regla) {
        this.rules = regla;
    }

    public String getRegla() {
        return this.rules;
    }
}

