/*
 * Decompiled with CFR 0.152.
 */
package modelo.simbolicos;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import modelo.simbolicos.DatosSimbolico;
import modelo.simbolicos.TIPO_DATO;

public class RelacionSimbolica {
    private String tablaOrigen;
    private List<String[]> concepto;
    private List<DatosSimbolico> datos;

    public RelacionSimbolica(String tablaOrigen) {
        this.tablaOrigen = tablaOrigen;
        this.datos = new LinkedList<DatosSimbolico>();
        this.concepto = new LinkedList<String[]>();
    }

    public List<String[]> getConcepto() {
        return this.concepto;
    }

    public String obtenerConcepto() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.concepto.size(); ++i) {
            r.append(this.concepto.get(i)[0]);
            if (i + 1 >= this.concepto.size()) continue;
            r.append(", ");
        }
        return r.toString();
    }

    public void agregarConcepto(String elemento, String rule) {
        for (String[] item : this.concepto) {
            if (!item[0].equals(elemento)) continue;
            item[1] = rule;
            return;
        }
        this.concepto.add(new String[]{elemento, rule});
    }

    public String getTablaOrigen() {
        return this.tablaOrigen;
    }

    public List<DatosSimbolico> getDatos() {
        return this.datos;
    }

    public void agregarDatosSimbolico(String tabla, TIPO_DATO sim) {
        for (int i = 0; i < this.datos.size(); ++i) {
            if (!this.datos.get(i).getColumna().equals(tabla) || this.datos.get(i).getDato() != sim) continue;
            return;
        }
        this.datos.add(new DatosSimbolico(tabla, sim));
    }

    public String getDatosSimbolicos() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.datos.size(); ++i) {
            r.append(this.datos.get(i).getNombreDato());
            if (i + 1 >= this.datos.size()) continue;
            r.append(",");
        }
        return r.toString();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < this.datos.size(); ++i) {
            r.append(this.datos.get(i).toString());
            if (i + 1 >= this.datos.size()) continue;
            r.append(", ");
        }
        return String.format("SELECT concept, %s FROM stable group by concept", r.toString());
    }

    public void removerDato(String columna, TIPO_DATO datoPorEliminar) {
        int i = 0;
        for (DatosSimbolico item : this.datos) {
            if (item.getColumna().equals(columna) && item.getDato() == datoPorEliminar) {
                this.datos.remove(i);
                return;
            }
            ++i;
        }
    }

    public void removerConcepto(String columna) {
        int i = 0;
        for (String[] item : this.concepto) {
            if (item[0].equals(columna)) {
                this.concepto.remove(i);
                return;
            }
            ++i;
        }
    }

    public String recuperarReglas() {
        ArrayList<String> rules = new ArrayList<String>();
        StringBuilder r = new StringBuilder();
        for (DatosSimbolico datosSimbolico : this.datos) {
            if (datosSimbolico.getRegla().length() <= 0) continue;
            rules.add(datosSimbolico.getRegla());
        }
        for (String[] stringArray : this.concepto) {
            if (stringArray[1].length() <= 0) continue;
            rules.add(stringArray[1]);
        }
        for (int i = 0; i < rules.size(); ++i) {
            r.append("(");
            r.append((String)rules.get(i));
            r.append(")");
            if (i + 1 == rules.size()) continue;
            r.append(" AND ");
        }
        return r.toString();
    }

    public void agregarRegla(String column, TIPO_DATO tipo, String regla) {
        int i;
        if (tipo == TIPO_DATO.CONCEPT) {
            for (i = 0; i < this.datos.size(); ++i) {
                if (!this.concepto.get(i)[0].equals(column)) continue;
                this.concepto.get((int)i)[1] = regla;
                return;
            }
        }
        for (i = 0; i < this.datos.size(); ++i) {
            if (!this.datos.get(i).getColumna().equals(column) || this.datos.get(i).getDato() != tipo) continue;
            this.datos.get(i).setRegla(regla);
            return;
        }
    }

    public String obtenerRegla(String columna, TIPO_DATO dato) {
        if (dato == TIPO_DATO.CONCEPT) {
            for (String[] item : this.concepto) {
                if (!item[0].equals(columna)) continue;
                return item[1];
            }
        }
        for (int i = 0; i < this.datos.size(); ++i) {
            if (!this.datos.get(i).getColumna().equals(columna) || this.datos.get(i).getDato() != dato) continue;
            return this.datos.get(i).getRegla();
        }
        return "";
    }
}

