/*
 * Decompiled with CFR 0.152.
 */
package modelo.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;

public class Conexion {
    private String driver = "org.postgresql.Driver";
    private String usuario;
    private String clave;
    private String connectString;
    private static Conexion instancia = null;
    private boolean estaConectado = false;

    protected Conexion(String bd, String usuario, String clave, String server, String port) throws Exception {
        this.connectString = "jdbc:postgresql://" + server + ":" + port + "/" + bd;
        this.clave = clave;
        this.usuario = usuario;
        this.probarConexion();
        this.estaConectado = true;
    }

    public static Conexion getInstancia(String bd, String usuario, String clave, String server, String port) throws Exception {
        return new Conexion(bd, usuario, clave, server, port);
    }

    public static Conexion getInstancia() throws Exception {
        if (instancia == null) {
            throw new Exception();
        }
        return instancia;
    }

    public boolean isEstaConectado() {
        return this.estaConectado;
    }

    private Connection getConexion() throws ClassNotFoundException, SQLException {
        Class.forName(this.driver);
        Connection con = DriverManager.getConnection(this.connectString, this.usuario, this.clave);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTableModel obtenerDatos(String tabla) {
        DefaultTableModel modelo = null;
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery("select * from " + tabla + " limit 1000");
            ResultSetMetaData metaDatos = rs.getMetaData();
            int noColumnas = metaDatos.getColumnCount();
            Object[] etiquetas = new Object[noColumnas];
            for (int i = 0; i < noColumnas; ++i) {
                etiquetas[i] = metaDatos.getColumnLabel(i + 1);
            }
            rs.last();
            Object[][] datos = new Object[rs.getRow()][noColumnas];
            rs.beforeFirst();
            int i = 0;
            while (rs.next()) {
                for (int j = 0; j < noColumnas; ++j) {
                    datos[i][j] = rs.getObject(j + 1);
                }
                ++i;
            }
            modelo = new DefaultTableModel(datos, etiquetas);
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            int w = 0;
            ++w;
            return w;
        }
        finally {
            return modelo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTableModel ejecutarSelect(String sql) {
        DefaultTableModel modelo = null;
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData metaDatos = rs.getMetaData();
            int noColumnas = metaDatos.getColumnCount();
            Object[] etiquetas = new Object[noColumnas];
            for (int i = 0; i < noColumnas; ++i) {
                etiquetas[i] = metaDatos.getColumnLabel(i + 1);
            }
            rs.last();
            Object[][] datos = new Object[rs.getRow()][noColumnas];
            rs.beforeFirst();
            int i = 0;
            while (rs.next()) {
                for (int j = 0; j < noColumnas; ++j) {
                    datos[i][j] = rs.getObject(j + 1);
                }
                ++i;
            }
            modelo = new DefaultTableModel(datos, etiquetas);
            stmt.close();
            con.close();
        }
        catch (Exception e) {
            int w = 0;
            ++w;
            return w;
        }
        finally {
            return modelo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> obtenerColumnas(String tabla) {
        ArrayList<String[]> items = new ArrayList<String[]>();
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery("select * from " + tabla + " limit 1");
            ResultSetMetaData metaDatos = rs.getMetaData();
            int noColumnas = metaDatos.getColumnCount();
            for (int i = 0; i < noColumnas; ++i) {
                String tipo = metaDatos.getColumnClassName(i + 1);
                String columna = metaDatos.getColumnLabel(i + 1);
                items.add(new String[]{columna, tipo});
            }
            stmt.close();
            con.close();
        }
        catch (Exception exception) {}
        finally {
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] obtenerTablas() {
        ArrayList<String> datos = new ArrayList<String>();
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select tablename from pg_tables where schemaname = 'public' order by tablename");
            while (rs.next()) {
                datos.add(rs.getString("tablename"));
            }
            stmt.close();
            con.close();
        }
        catch (Exception exception) {}
        finally {
            return datos.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepararVistaSimbolica(String tabla, String obtenerConcepto) {
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select stable('" + tabla + "', '" + obtenerConcepto + "')");
            stmt.close();
            con.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepararTablaRSDA(String tabla, String obtenerConcepto, String datos) {
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select createRSDA('" + tabla + "', '" + obtenerConcepto + "', '" + datos + "')");
            stmt.close();
            con.close();
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepararVistaSimbolica(String tabla, String obtenerConcepto, String rules) {
        try {
            Connection con = this.getConexion();
            Statement stmt = con.createStatement();
            String SQL = "select stable('" + tabla + "', '" + obtenerConcepto + "', '" + rules + "')";
            ResultSet rs = stmt.executeQuery(SQL);
            stmt.close();
            con.close();
        }
        catch (Exception e) {}
    }

    private void probarConexion() throws Exception {
        Connection con = this.getConexion();
        Statement stmt = con.createStatement();
        String SQL = "select 1";
        ResultSet rs = stmt.executeQuery(SQL);
    }

    public void guardarCSV(String tabla, String parent) throws Exception {
        Connection con = this.getConexion();
        Statement stmt = con.createStatement();
        String SQL = "select exportCSV('" + tabla + "', '" + parent + "')";
        ResultSet rs = stmt.executeQuery(SQL);
        stmt.close();
        con.close();
    }

    public void guardarTabla(String tablaSeleccionada, String a) throws Exception {
        Connection con = this.getConexion();
        Statement stmt = con.createStatement();
        String SQL = "create table " + a + " as select * from " + tablaSeleccionada;
        stmt.execute(SQL);
        stmt.close();
        con.close();
    }
}

