/*
 * Decompiled with CFR 0.152.
 */
package aplicacion.modelo;

import java.io.File;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import modelo.GestorDatos;
import modelo.simbolicos.RelacionSimbolica;
import modelo.simbolicos.TIPO_DATO;
import vista.IObservador;
import vista.VistaConexiones;
import vista.VistaReglas;
import vista.VistaTablas;

public class ControlAplicacion {
    private GestorDatos modelo = null;
    private JFrame vistaPrincipal = null;

    public ControlAplicacion() {
        try {
            this.modelo = GestorDatos.Instancia();
            this.modelo.conectar("", "", "", "", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JFrame getVistaPrincipal() {
        if (this.vistaPrincipal == null) {
            this.vistaPrincipal = new VistaTablas(this);
            this.modelo.AgregarObservador((IObservador)((Object)this.vistaPrincipal));
        }
        return this.vistaPrincipal;
    }

    public DefaultListModel obtenerTablas() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String actual : this.modelo.obtenerTablas()) {
            listModel.addElement(actual);
        }
        return listModel;
    }

    public List<String[]> obtenerColumnas(String tabla) {
        return this.modelo.obtenerColumnas(tabla);
    }

    public TableModel obtenerTabla(String t1) {
        return this.modelo.obtenerTabla(t1);
    }

    public void agregarConcepto(String tablaDatos, String columna, String rule) {
        this.modelo.agregarConcepto(tablaDatos, columna, rule);
    }

    public TableModel obtenerSimbolos(String tablaSeleccionada) {
        return this.modelo.obtenerDatosSimbolicos(tablaSeleccionada);
    }

    public void agregarDatoSimbolico(String tablaSeleccionada, String toString, TIPO_DATO tipO_DATO) {
        this.modelo.agregarDatoSimbolico(tablaSeleccionada, toString, tipO_DATO);
    }

    public TableModel obtenerTablaSimbolica(String tablaSeleccionada) {
        TableModel procesado = new DefaultTableModel();
        try {
            procesado = this.modelo.mostrarResultadoSimbolico(tablaSeleccionada);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return procesado;
    }

    public void removerDatoSimbolico(String tablaSeleccionada, String columna, TIPO_DATO datoPorEliminar) {
        this.modelo.removerDatoSimbolico(tablaSeleccionada, columna, datoPorEliminar);
    }

    public void mostrarReglas(String tabla, String columna, TIPO_DATO dato) {
        VistaReglas reglas = new VistaReglas(this, tabla, columna, dato);
        reglas.setVisible(true);
    }

    public void guardarRegla(String tabla, String column, TIPO_DATO dato, String regla) {
        this.modelo.guardarRegla(tabla, column, dato, regla);
    }

    public String obtenerRegla(String tabla, String columna, TIPO_DATO dato) {
        return this.modelo.obtenerRegla(tabla, columna, dato);
    }

    public void conectar(String text, String text0, String text1, String server, String port) throws Exception {
        this.modelo.conectar(text, text0, text1, server, port);
    }

    public void mostrarConexion() {
        VistaConexiones con = new VistaConexiones(this);
        con.setVisible(true);
    }

    public boolean estaConectado() {
        return this.modelo.estaConectado();
    }

    public void guardarCSV(String tabla) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("CVS files", "csv"));
        fc.setDialogType(1);
        int opcion = fc.showDialog(this.getVistaPrincipal(), "Save cvs file");
        if (opcion == 0) {
            File file = fc.getSelectedFile();
            String ruta = file.getAbsolutePath() + ".csv";
            try {
                this.modelo.guardarCSV(tabla, ruta);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "Error when file save", 0);
            }
        }
    }

    public void guardarRSDA(String tabla) {
        RelacionSimbolica rel = this.modelo.getRelacion(tabla);
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileNameExtensionFilter("RSDA files", "rsda"));
        fc.setDialogType(1);
        int opcion = fc.showDialog(this.getVistaPrincipal(), "Save rsda file");
        if (opcion == 0) {
            File file = fc.getSelectedFile();
            this.modelo.crearRSDA(tabla, rel.obtenerConcepto(), rel.getDatosSimbolicos());
            String ff = file.getAbsolutePath() + ".rsda";
            try {
                this.modelo.guardarCSV("rsda", ff);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.toString(), "Error when file save", 0);
            }
        }
    }

    public void guardarTabla(String tablaSeleccionada) {
        String a = JOptionPane.showInputDialog(null, (Object)"What is the name of the new table?");
        try {
            this.modelo.guardarTabla(tablaSeleccionada, a);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Error when table save", 0);
        }
    }
}

