/*
 * Decompiled with CFR 0.152.
 */
package vista;

import aplicacion.modelo.ControlAplicacion;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import modelo.simbolicos.TIPO_DATO;
import vista.IObservador;
import vista.PanelFondo;

public class VistaTablas
extends JFrame
implements IObservador {
    private ControlAplicacion control;
    private JButton cmdAgregar;
    private JButton cmdAgregarSimbolos1;
    private JButton cmdSimbolic;
    private JButton cmdSources;
    private JComboBox comboColumna;
    private JTable comboDetallesSimbolicos;
    private JList comboTablas;
    private JComboBox comboTipo;
    private JMenu jMenu1;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JTable jTable3;
    private Label label10;
    private Label label2;
    private Label label6;
    private Label label7;
    private Label label8;
    private Label label9;
    private Label lblTitulo;
    private JTable tablaDatos;
    private String tablaSeleccionada = null;
    private boolean modoSimbolico = false;
    private boolean modoDatos = false;
    private List<String[]> datosColumnas;
    private String columna;

    public VistaTablas(ControlAplicacion _control) {
        this.initComponents();
        this.datosColumnas = new ArrayList<String[]>();
        this.control = _control;
        this.setTitle("Relational to symbolic transform tool - 2013");
        this.getContentPane().setBackground(Color.WHITE);
        this.add(new PanelFondo(this.getWidth()));
        this.jPanel5.setVisible(false);
        this.actualizarComboTipos();
        this.repaint();
        this.setExtendedState(6);
        this.Actualizar(this.rootPane, null);
    }

    @Override
    public void Actualizar(Object referencia, Event e) {
        try {
            this.comboTablas.setModel(this.control.obtenerTablas());
            this.comboDetallesSimbolicos.setModel(this.control.obtenerSimbolos(this.tablaSeleccionada));
            this.datosColumnas = this.control.obtenerColumnas(this.tablaSeleccionada);
            DefaultComboBoxModel<String> insumo = new DefaultComboBoxModel<String>();
            for (String[] col : this.datosColumnas) {
                insumo.addElement(col[0]);
            }
            this.comboColumna.setModel(insumo);
            this.actualizarComboTipos();
            if (this.modoSimbolico) {
                this.tablaDatos.setModel(this.control.obtenerTablaSimbolica(this.tablaSeleccionada));
                this.jPanel5.setVisible(true);
            }
            if (this.modoDatos) {
                this.tablaDatos.setModel(this.control.obtenerTabla(this.tablaSeleccionada));
                this.jPanel5.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jScrollPane4 = new JScrollPane();
        this.jTable3 = new JTable();
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jPanel3 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.comboTablas = new JList();
        this.label6 = new Label();
        this.jPanel1 = new JPanel();
        this.comboColumna = new JComboBox();
        this.comboTipo = new JComboBox();
        this.jScrollPane5 = new JScrollPane();
        this.comboDetallesSimbolicos = new JTable();
        this.label7 = new Label();
        this.label8 = new Label();
        this.cmdAgregarSimbolos1 = new JButton();
        this.label9 = new Label();
        this.label10 = new Label();
        this.cmdAgregar = new JButton();
        this.cmdSources = new JButton();
        this.cmdSimbolic = new JButton();
        this.jPanel2 = new JPanel();
        this.label2 = new Label();
        this.lblTitulo = new Label();
        this.jPanel5 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tablaDatos = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem6 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu4 = new JMenu();
        this.jTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane4.setViewportView(this.jTable3);
        this.jMenuItem2.setText("Remove");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("Create or replace rule");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem3);
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 255));
        this.setForeground(Color.gray);
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.comboTablas.setSelectionMode(0);
        this.comboTablas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VistaTablas.this.ActualizarTabla(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.comboTablas);
        this.label6.setFont(new Font("Dialog", 1, 12));
        this.label6.setName("");
        this.label6.setText("Tables from database");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.comboColumna.setModel(new DefaultComboBoxModel<String>(new String[]{"*"}));
        this.comboColumna.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                VistaTablas.this.comboColumnaItemStateChanged(evt);
            }
        });
        this.comboDetallesSimbolicos.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Variables", "Symbolic types", "Rule"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.comboDetallesSimbolicos.setComponentPopupMenu(this.jPopupMenu1);
        this.comboDetallesSimbolicos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                VistaTablas.this.actualizarClick(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.comboDetallesSimbolicos);
        this.label7.setFont(new Font("Dialog", 0, 10));
        this.label7.setName("");
        this.label7.setText("Symbolic type");
        this.label8.setFont(new Font("Dialog", 0, 10));
        this.label8.setName("");
        this.label8.setText("Variable");
        this.cmdAgregarSimbolos1.setText("...");
        this.cmdAgregarSimbolos1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.SetRules(evt);
            }
        });
        this.label9.setFont(new Font("Dialog", 0, 10));
        this.label9.setName("");
        this.label9.setText("Rule");
        this.label10.setFont(new Font("Dialog", 0, 10));
        this.label10.setName("");
        this.label10.setText("Add");
        this.cmdAgregar.setBackground(new Color(255, 255, 255));
        this.cmdAgregar.setIcon(new ImageIcon(this.getClass().getResource("/Imagenes/agregar.png")));
        this.cmdAgregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.cmdAgregarActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.label8, -2, -1, -2)).addComponent(this.comboColumna, -2, 179, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.label7, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTipo, -2, 168, -2))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.label9, -2, -1, -2).addGap(51, 51, 51)).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.cmdAgregarSimbolos1, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 39, Short.MAX_VALUE))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cmdAgregar, -2, 23, -2).addGap(0, 13, Short.MAX_VALUE)).addComponent(this.label10, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.label10, -2, -1, -2).addGap(8, 8, 8).addComponent(this.cmdAgregar, -2, 25, -2).addGap(4, 4, 4)).addGroup(jPanel1Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.label9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.label8, -2, -1, -2).addComponent(this.label7, -2, -1, -2)).addGap(9, 9, 9))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboTipo).addComponent(this.comboColumna).addComponent(this.cmdAgregarSimbolos1)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -2, 214, -2).addGap(68, 68, 68)));
        this.cmdSources.setText("Sources table");
        this.cmdSources.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.cmdSourcesActionPerformed(evt);
            }
        });
        this.cmdSimbolic.setText("Symbolic table");
        this.cmdSimbolic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.cmdSimbolicActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label6, -2, -1, -2).addComponent(this.jScrollPane2, -2, 158, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.cmdSources, -2, 116, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cmdSimbolic, -2, 122, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel1, -2, 296, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmdSources).addComponent(this.cmdSimbolic)).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.label6, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jScrollPane2))).addContainerGap()));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.label2.setBackground(new Color(255, 255, 255));
        this.label2.setFont(new Font("Arial", 0, 12));
        this.label2.setText("Version 2013");
        this.lblTitulo.setBackground(new Color(255, 255, 255));
        this.lblTitulo.setFont(new Font("Arial", 1, 18));
        this.lblTitulo.setText("Relational to symbolic transform tool");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitulo, -2, -1, -2).addComponent(this.label2, -2, -1, -2)).addContainerGap(211, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lblTitulo, -2, -1, -2).addGap(1, 1, 1).addComponent(this.label2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.tablaDatos.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.tablaDatos);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 111, Short.MAX_VALUE).addContainerGap()));
        this.jMenu1.setText("File");
        this.jMenuItem4.setText("Export to CSV");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setText("Export to RSDA");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem6.setText("Save as database table");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu5.setText("Connection");
        this.jMenuItem1.setText("Connecto to Postgresql");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VistaTablas.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu5);
        this.jMenu4.setText("Help");
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(191, 191, 191).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void ActualizarTabla(MouseEvent evt) {
        this.tablaSeleccionada = this.comboTablas.getSelectedValue().toString();
        this.Actualizar(this.rootPane, null);
        this.actualizarComboTipos();
    }

    public void actualizarTabla(TableModel modelo) {
        this.tablaDatos.setModel(modelo);
    }

    private void cmdSourcesActionPerformed(ActionEvent evt) {
        this.modoSimbolico = false;
        this.modoDatos = true;
        this.Actualizar(this.rootPane, null);
    }

    private void cmdSimbolicActionPerformed(ActionEvent evt) {
        this.modoSimbolico = true;
        this.modoDatos = false;
        this.Actualizar(this.rootPane, null);
    }

    private TIPO_DATO getTipoDato(String cadena) {
        if (cadena.equals("CONCEPT")) {
            return TIPO_DATO.CONCEPT;
        }
        if (cadena.equals("CONTINUOUS")) {
            return TIPO_DATO.CONTINUOUS;
        }
        if (cadena.equals("INTERVAL")) {
            return TIPO_DATO.INTERVAL;
        }
        if (cadena.equals("MODAL")) {
            return TIPO_DATO.MODAL;
        }
        if (cadena.equals("MULTIVALUED_MODAL")) {
            return TIPO_DATO.MULTIVALUED_MODAL;
        }
        if (cadena.equals("HISTOGRAM")) {
            return TIPO_DATO.HISTOGRAM;
        }
        return null;
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        int filaSeleccionada = this.comboDetallesSimbolicos.getSelectedRow();
        String tipo = this.comboDetallesSimbolicos.getModel().getValueAt(filaSeleccionada, 1).toString();
        TIPO_DATO datoPorEliminar = this.getTipoDato(tipo);
        this.control.removerDatoSimbolico(this.tablaSeleccionada, this.columna, datoPorEliminar);
    }

    private void cmdAgregarActionPerformed(ActionEvent evt) {
        this.agregarSimbolo();
    }

    private boolean esAditivo(String columna) {
        for (String[] item : this.datosColumnas) {
            if (!columna.equals(item[0]) || item[1].equals("java.lang.String")) continue;
            return true;
        }
        return false;
    }

    private void actualizarComboTipos() {
        this.columna = this.comboColumna.getSelectedItem().toString();
        boolean esAditivo = this.esAditivo(this.columna);
        DefaultComboBoxModel<String> modelo = new DefaultComboBoxModel<String>();
        modelo.addElement("CONCEPT");
        modelo.addElement("MODAL");
        modelo.addElement("MULTIVALUED_MODAL");
        if (esAditivo) {
            modelo.addElement("CONTINUOUS");
            modelo.addElement("INTERVAL");
            modelo.addElement("HISTOGRAM");
        }
        this.cmdAgregarSimbolos1.setEnabled(esAditivo);
        this.comboTipo.setModel(modelo);
    }

    private void comboColumnaItemStateChanged(ItemEvent evt) {
        this.actualizarComboTipos();
    }

    private void SetRules(ActionEvent evt) {
        TIPO_DATO dato = this.getTipoDato(this.comboTipo.getSelectedItem().toString());
        this.control.mostrarReglas(this.tablaSeleccionada, this.columna, dato);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        String select = this.comboDetallesSimbolicos.getModel().getValueAt(this.comboDetallesSimbolicos.getSelectedRow(), 1).toString();
        String colum = this.comboDetallesSimbolicos.getModel().getValueAt(this.comboDetallesSimbolicos.getSelectedRow(), 0).toString();
        TIPO_DATO dato = this.getTipoDato(select);
        this.control.mostrarReglas(this.tablaSeleccionada, colum, dato);
    }

    private void actualizarClick(MouseEvent evt) {
        String select = this.comboDetallesSimbolicos.getModel().getValueAt(this.comboDetallesSimbolicos.getSelectedRow(), 0).toString();
        this.jMenuItem3.setEnabled(this.esAditivo(select));
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.control.mostrarConexion();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.control.guardarCSV(this.tablaSeleccionada);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.control.guardarRSDA(this.tablaSeleccionada);
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.control.guardarTabla(this.tablaSeleccionada);
    }

    private void agregarSimbolo() {
        String detalleTipo = this.comboTipo.getSelectedItem().toString();
        TIPO_DATO dato = this.getTipoDato(detalleTipo);
        if (dato == TIPO_DATO.CONCEPT) {
            this.control.agregarConcepto(this.tablaSeleccionada, this.columna, "");
        } else {
            this.control.agregarDatoSimbolico(this.tablaSeleccionada, this.columna, dato);
        }
    }
}

